<?php

namespace Modules\Admin\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use AWS\CRT\HTTP\Request;
use Illuminate\Support\Facades\Session;
use Modules\Admin\app\Models\Admin;
use Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin\AdminStoreRequest;
use Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin\AdminUpdateRequest;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Role\app\Models\Role;


class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('user.access');
        $roles = Role::latest()->whereState(1)->get();

        $list_users = Admin::all();
        $users = Admin::
        when(Request()->q != null,function ($query){
            return $query->where('name','LIKE','%'.Request()->q."%")
            ->orWhere('family','LIKE','%'.Request()->q."%")
            ->orWhere('mobile','LIKE','%'.Request()->q."%")
            ->orWhere('email','LIKE','%'.Request()->q."%");
        })
        ->latest()->paginate(15);


        return view('admin::Dashboard.Frest.admin.index',compact('users','list_users','roles'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('user.access');
        $roles = Role::latest()->get();



        return view('admin::Dashboard.Frest.admin.create',compact('roles'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AdminStoreRequest $request)
    {
        $this->authorize('user.access');



        $admin = Admin::create([
            'name' => $request->name,
            'image' => File::uploadByFileManager($request->image),
            'state' => $request->state,
            'send_sms' => 0,
            'mobile' => $request->mobile,
            'username' => $request->username,
            'password' => bcrypt($request->password),
            'type' => 'admin',
        ]);

        if(count($request->input('role_id')) > 0){
            foreach ($request->input('role_id') as $id){
                $admin->roles()->create([
                    'role_id' => $id,
                ]);
            }
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.admin.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Admin $admin)
    {
       //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('user.access');

        $admin = Admin::query()->find($id);
        $roles = Role::latest()->get();


        return view('admin::Dashboard.Frest.admin.edit',compact(['roles','admin']));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(AdminUpdateRequest $request, Admin $admin)
    {
        $this->authorize('user.access');




        $admin->name = $request->name;
        $admin->image = $request->image != null ? File::uploadByFileManager($request->image) : $admin->image;
        $admin->state = $request->state;
        $admin->send_sms = 0;
        $admin->mobile = $request->mobile;
        $admin->username = $request->username;
        $admin->password = $request->password != null ? bcrypt($request->password) : $admin->password;
        $admin->type = 'admin';


        $admin->update();

        $admin->roles()->delete();
        if(count($request->input('role_id')) > 0){
            foreach ($request->input('role_id') as $id){
                $admin->roles()->create([
                    'role_id' => $id,
                ]);
            }
        }
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.admin.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Admin $admin)
    {
        $this->authorize('user.access');
        $admin->delete();
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.admin.index');
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('type.delete');
            Admin::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('type.edit');
            Admin::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('type.edit');
            Admin::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
