<?php

namespace Modules\Admin\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;
use Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin\ForgotPasswordRequest;
use Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin\ResetPasswordRequest;
use Modules\Dashboard\app\Http\Requests\Dashboard\Frest\Auth\AdminLoginRequest;

class AuthController extends Controller
{

    public function login(AdminLoginRequest $request){

        $credentials = $request->only(['username','password']);


        if(!Auth::guard('admin')->attempt($credentials))
            return redirect()->back();

        $admin = Auth::guard('admin')->user();

        return redirect('/admin/panel');

    }

    public function logOut()
    {
        Auth::guard('admin')->logout();
        return redirect('/');
    }

    public function ForgotPassword(ForgotPasswordRequest $request)
    {
        $status = Password::sendResetLink($request->only('email'));
        return $status === Password::RESET_LINK_SENT
            ? back()->with(['success' => 'لینک فراموشی رمزعبور به ایمیل شما ارسال شد.'])
            : back()->withErrors(['errors' => 'لطفا 60 ثانیه بعد مجددا تلاش کنید.']);
    }

    public function ResetPassword(ResetPasswordRequest $request)
    {
        $status = Password::reset(
            $request->only('email', 'password', 'password_confirmation','token'),
            function ($user,$password) {
                $user->forceFill([
                    'password' => Hash::make($password)
                ])->setRememberToken(Str::random(60));
                $user->save();
                event(new PasswordReset($user));
            }
        );
        return $status === Password::PASSWORD_RESET
            ? redirect()->route('login')->with('success', 'گذرواژه شما با موفقیت ویرایش شد.')
            : back()->withErrors(['errors' => 'عملیات ویرایش گذرواژه ناموفق بود.']);
    }
}
