<?php

namespace Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin;

use Illuminate\Foundation\Http\FormRequest;

class AdminStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'mobile' => 'nullable|unique:admins|numeric|min:11',
            'username' => 'required|min:3|unique:admins',
            'password' => 'required|min:8',
            'state' => 'required',
        ];
    }
}
