<?php

namespace Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin;


use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class AdminUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'name' => 'required',
            'mobile' => ['nullable','min:11','numeric', Rule::unique('admins')->ignore($this->route('admin'))],
            'username' => ['min:3','required' , Rule::unique('admins')->ignore($this->route('admin'))],
            'password' => 'nullable','min:8',
            'state' => 'required',
        ];
    }
}
