<?php

namespace Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ForgotPasswordRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required|email|exists:admins'
        ];
    }

    public function messages()
    {
        return [
            'email.required' => 'وارد کردن فیلد ایمیل اجباری می باشد.',
            'email.email' => 'فرمت ایمیل وارد شده صحیح نمی باشد.',
            'email.exists' => 'ایمیل وارد شده ثبت نشده است.'
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
