<?php

namespace Modules\Admin\app\Http\Requests\Dashboard\Frest\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ResetPasswordRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'token' => 'required',
            'email' => 'required|email|exists:admins',
            'password' => 'required|min:6|confirmed',
        ];
    }

    public function messages()
    {
        return [
            'token.required' => 'پارامتر توکن به درستی ارسال نشده است.',
            'email.required' => 'پارامتر ایمیل به درستی وارد نشده است.',
            'email.email' => 'فرمت ایمیل وارد شده نادرست است.',
            'email.exists' => 'ایمیل وارد شده تاکنون ثبت نشده است.',
            'password.required' => 'وارد کردن فیلد گذرواژه الزامی است.',
            'password.min' => 'گذرواژه باید بیش از 6 کاراکتر باشد.',
            'password.confirmed' => 'گذرواژه های وارد شده باهم همخوانی ندارند.'
        ];
    }
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
