<?php

namespace Modules\Admin\app\Models;




use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Modules\Category\app\Models\Category;
use Modules\Role\app\Models\RoleModel;

class Admin extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id','name',
        'mobile', 'username','password',
         'image',
        'state', 'send_sms',
        'type',
    ];


    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function getAuthPassword()
    {
        return $this->password;
    }

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
    public function roles()
    {
        return $this->morphMany(RoleModel::class, 'roleModel','model_type','model_id');
    }

    public function hasRole($roles){


        if (count($this->roles->whereIn('role_id',$roles)) > 0){
            return true;
        };

        return false;
    }


    public function getCategoriesRoles(){


        $categories = Category::whereHas('roles', function ($query) {
            $query->where('id',$this->roles->pluck('id'));
        })->get();

        return $categories;

    }

    public function getImageAttribute($value){
        return $value;
    }
}
