<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admins', function (Blueprint $table) {

            $table->id();
            $table->string('name');
            $table->string('family')->nullable();
            $table->string('email')->nullable()->unique();
            $table->string('mobile')->nullable()->unique();
            $table->text('address')->nullable();
            $table->string('birthday')->nullable();
            $table->boolean('send_email')->default(0);
            $table->boolean('send_sms')->default(0);
            $table->string('phone')->nullable()->unique();
            $table->string('image')->nullable();
            $table->boolean('state')->default(0);
            $table->string('username')->nullable()->unique();
            $table->string('password')->nullable();
            $table->string('type')->default('user');


            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admins');
    }
};
