@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

@section('style')
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/select2/select2.css')}}" />
@endsection

@section('script')
    <script src="{{asset('modules/core/vendor/libs/select2/select2.js')}}"></script>
    <script>
        $(".select2").select2();
    </script>
@endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{route('admin.admin.update',$admin->id)}}" method="post">
                            @csrf
                            @method('PATCH')
                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="title">نام</label>
                                            <input type="text" id="name"  name="name" class="form-control" placeholder="نام" value="{{$admin->name}}">
                                            @if($errors->has('name'))
                                                <div data-field="name" class="text-danger">{{ $errors->first('name') }}</div>
                                            @endif
                                        </div>



                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="title">موبایل</label>
                                            <input type="text" id="mobile"  name="mobile" class="form-control" placeholder="موبایل" value="{{$admin->mobile}}">
                                            @if($errors->has('mobile'))
                                                <div data-field="mobile" class="text-danger">{{ $errors->first('mobile') }}</div>
                                            @endif
                                        </div>


                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="col-md-12">
                                        <label class="form-label" for="title">تصویر</label>
                                        <div class="input-group">
                                            <input type="text" id="image1" class="form-control" name="image"
                                                   aria-label="Image" aria-describedby="button-image">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="state">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="state" name="state" class="form-select">
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{'1' == $admin->state ? 'selected' : ''}}>فعال</option>
                                                <option value="0" {{'2' == $admin->state ? 'selected' : ''}}>غیر فعال</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <label for="select2Multiple" class="form-label">نقش ها</label>
                                        <select id="select2Multiple" class="select2 form-select" name="role_id[]" multiple>
                                            @foreach($roles as $role)
                                                <option value="{{$role->id}}" {{in_array($role->id,$admin->roles->pluck('role_id')->toArray()) ? 'selected' : ''}}>{{$role->title}}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="title">نام کاربری</label>
                                        <input type="text" id="username"  name="username" class="form-control" placeholder="نام کاربری" value="{{$admin->username}}">
                                        @if($errors->has('username'))
                                            <div data-field="username" class="text-danger">{{ $errors->first('username') }}</div>
                                        @endif
                                    </div>


                                    <div class="col-md-12">
                                        <label class="form-label" for="title">رمز عبور</label>
                                        <input type="text" id="password"  name="password" class="form-control" placeholder="رمز عبور" value="{{old('password')}}">
                                        @if($errors->has('password'))
                                            <div data-field="password" class="text-danger">{{ $errors->first('password') }}</div>
                                        @endif
                                    </div>





                                </div>



                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{route('admin.admin.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                            </div>

                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>




@endsection
