@extends('admin::Dashboard.Frest.auth.master')

@section('content')

    <!-- Login -->
    <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-sm-5 p-4">
        <div class="w-px-400 mx-auto">

            <h4 class="mb-2">به پنل مدیریت {{env("APP_NAME")}} خوش آمدید!</h4>
            <p class="mb-2">لطفا وارد حساب خود شوید</p>
            @if(\Illuminate\Support\Facades\Session::has('success'))
                <div class="alert alert-success">
                    {{ \Illuminate\Support\Facades\Session::get('success') }}
                </div>
            @endif
            <form class="mb-3" action="/admin/login" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="email" class="form-label"> نام کاربری</label>
                    <input type="text" class="form-control text-start" dir="ltr" id="email" name="username" placeholder="نام کاربری خود را وارد کنید" autofocus>
                    @if($errors->has('username'))
                        <div data-field="username" class="text-danger">{{ $errors->first('username') }}</div>
                    @endif
                </div>
                <div class="mb-3 form-password-toggle">
                    <div class="input-group input-group-merge">
                        <input type="password" id="password" class="form-control text-start" dir="ltr" name="password" placeholder="············" aria-describedby="password">
                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                        @if($errors->has('password'))
                            <div data-field="password" class="text-danger">{{ $errors->first('password') }}</div>
                        @endif
                    </div>
                </div>
                <button class="btn btn-primary d-grid w-100">ورود</button>
            </form>

            <div class="divider my-4">
                <div class="divider-text">ما را در شبکه اجتماعی دنبال کنید</div>
            </div>

            <div class="d-flex justify-content-center">
                <a href="javascript:;" class="btn btn-icon btn-label-facebook me-3">
                    <i class="tf-icons bx bxl-facebook"></i>
                </a>

                <a href="javascript:;" class="btn btn-icon btn-label-google-plus me-3">
                    <i class="tf-icons bx bxl-google-plus"></i>
                </a>

                <a href="javascript:;" class="btn btn-icon btn-label-twitter">
                    <i class="tf-icons bx bxl-twitter"></i>
                </a>
            </div>

        </div>
    </div>
    <!-- /Login -->

    @endsection
