<?php


use Illuminate\Support\Facades\Route;
use Modules\Admin\Http\Middleware\Dashboard\Frest\ResetPasswordToken;

Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('admin','AdminController');
    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/admins','AdminController@bulkAction')->name('admins');
    });
});

Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->group(function(){
    Route::view('/forgot-password',"admin::Dashboard." . config('app.template_admin') . ".auth.forgot-password");
    Route::post('/forgot-password',"AuthController@ForgotPassword")->name('forgotPassword');
    Route::view('/reset-password/token={token}&email={email}',"admin::Dashboard." . config('app.template_admin') . ".auth.reset-password")->middleware(ResetPasswordToken::class);
    Route::post("/reset-password","AuthController@ResetPassword")->name('resetPassword');
    Route::get('/logout','AuthController@logOut')->name('logout');
    Route::post('/login','AuthController@login');
});

