<?php

namespace Modules\Ads\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Modules\Ads\app\Models\Ads;
use Modules\Ads\app\Http\Requests\Dashboard\Frest\Ads\AdsStoreRequest;
use Modules\Ads\app\Http\Requests\Dashboard\Frest\Ads\AdsUpdateRequest;
use Modules\Category\app\Models\Category;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Page\app\Models\Page;
use Modules\Service\app\Models\Service;
use Modules\Service\app\Models\ServiceModel;

class AdsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */







    public function index()
    {
        $this->authorize('ads.access');
        $user = Auth::guard('admin')->user();

        $categories = Category::whereType('ads')->whereType('news')->whereType('news')->whereType('news')->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->get();


            $ads = Ads::when(Request()->tran_id != null,function ($query){
                $query->where('tran_id',Request()->tran_id);
            })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })->latest()->paginate(15);

        return view('ads::Dashboard.Frest.ads.index',compact('ads'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('ads.create');
        $user = Auth::guard('admin')->user();
        $trans = Ads::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();
         $services = Service::where('model','ads')->latest()->get();
        $categories = Category::whereType('ads')->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->get();

        return view('ads::Dashboard.Frest.ads.create',compact('categories','services','trans'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AdsStoreRequest $request)
    {
        $this->authorize('ads.create');

        $path = File::uploadByFileManager($request->image);

        $publish_up = null; $publish_down=null;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }


        $ads = Ads::create([
            'title' => $request->title,
            'script' => $request->script,
            'link' => $request->link,
            'image' => $path,
            'state' => $request->state,
            'publish_down' => $publish_down,
            'publish_up' => $publish_up,
            'lang' => $request->lang,
            'tran_id' => $request->tran_id,
        ]);

        $ads->categories()->sync($request->categories);

        $ads->services()->delete();

        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $ads->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.ads.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('ads.edit');
        $ads = Ads::find($id);
        if($ads->tran_id != null){
            $tran = Ads::find($ads->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $ads->translates->pluck('lang')->toArray();
        }
        $user = Auth::guard('admin')->user();
         $services = Service::where('model','ads')->latest()->get();
        $categories = Category::whereType('ads')->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->get();

        return view('ads::Dashboard.Frest.ads.edit',compact('ads','categories','trans','services'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(AdsUpdateRequest $request, $id)
    {
        $this->authorize('ads.edit');

        $ads = Ads::find($id);

        $path = File::uploadByFileManager($request->image);

        $publish_up = $ads->publish_up; $publish_down = $ads->publish_down;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }


        $ads->title = $request->title;
        $ads->script = $request->script;
        $ads->link = $request->link;
        $ads->lang = $request->lang;
        $ads->image = $path == null ? $ads->image : $path;
        $ads->state =  $request->state;
        $ads->publish_down = $publish_down;
        $ads->publish_up = $publish_up;
        $ads->update();
        $ads->categories()->sync($request->categories);

        $ads->services()->delete();

        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $ads->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }

        Session::flash('success','با موفقیت انجام شد');

        return redirect()->route('admin.ads.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('ads.delete');
        $ads = Ads::find($id);
        $ads->delete();


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.ads.index');
    }



    public function bulkAction()
    {
        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('ads.delete');
            Ads::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('ads.edit');
            Ads::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('ads.edit');
            Ads::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
