<?php

namespace Modules\Ads\app\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Category\app\Models\Category;
use Modules\Language\app\Models\Language;
use Modules\Service\app\Models\ServiceModel;

class Ads extends Model
{
    use SoftDeletes;
    protected $fillable = [ 'title','script','image','link','state',
                            'special','order','click' ,
                            'publish_up','publish_down','date_up','time_up',
                            'date_down','time_down','tran_id', 'lang'];



    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query->where('state',1)
            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);
            });
    }


    public function translates(){
        return $this->hasMany(Ads::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }

    public function categories()
    {
        return $this->morphToMany(Category::class, 'catgable');
    }


    public function getImageUrlAttribute($value){

       return $this->image;

    }

    public function services()
    {
        return $this->morphMany(ServiceModel::class, 'serviceModel','model_type','model_id');
    }


}


