<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ads', function (Blueprint $table) {
            $table->id();
            $table->string('title');

            $table->text('script')->nullable();
            $table->string('image')->nullable();
            $table->string('link')->nullable();

            $table->boolean('state')->default(0);
            $table->boolean('special')->default(0);

            $table->integer('order')->nullable();
            $table->integer('click')->nullable();


            $table->unsignedBigInteger('admin_id')->nullable();
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('set null');

            $table->timestamp('publish_up')->nullable();
            $table->timestamp('publish_down')->nullable();


            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ads');
    }
}
