@extends('core::Dashboard.Frest.Layouts.master')

@section('title')بنر تبلیغاتی@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
        @endsection

    @section('script')
        <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

        <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

        <script>
            CKEDITOR.replace('body' ,{
            });
            $('#submit').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) {
                    e.preventDefault();
                    return false;
                }
            });
        </script>


    @endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>

                    </ul>
                </div>

                <div class="tab-content">
                    <form id="save" action="{{route('admin.ads.update',$ads->id)}}" method="post">
                        {{ csrf_field() }}
                        @method('patch')
                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">


                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{$ads->title}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-4">
                                            <label class="form-label" for="title">فایل</label>
                                            <div class="input-group">
                                                <input type="text" id="image1" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image" value="{{$ads->image}}">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label" for="title">لینک</label>
                                            <input type="text" id="link"  name="link" class="form-control" placeholder="لینک " value="{{$ads->link}}">
                                            @if($errors->has('link'))
                                                <div data-field="link" class="text-danger">{{ $errors->first('link') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">اسکریپت</label>
                                            <textarea type="text" id="script"  name="script" class="form-control" >{{$ads->script}}</textarea>
                                            @if($errors->has('script'))
                                                <div data-field="script" class="text-danger">{{ $errors->first('script') }}</div>
                                            @endif
                                        </div>





                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="row">



                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="state">زبان</label>
                                            <div class="position-relative">
                                                <select required id="lang" name="lang" class="form-select" >
                                                    @foreach($languages as $language)
                                                        @if(!in_array($language->name,$trans) || $language->name == $ads->lang)
                                                            <option value="{{$language->name}}" {{$language->name == $ads->lang ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>


                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select required id="state" name="state" class="form-select" >
                                                    <option value="1" {{'1' == $ads->state ? 'selected' : ''}}>فعال</option>
                                                    <option value="0" {{'0' == $ads->state ? 'selected' : ''}}>غیر فعال</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی</label>
                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category,'model' => $ads])
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">سرویس های نمایشی</label>
                                            <select id="selectpickerSelectDeselect" name="service_ids[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($services as $service)
                                                    <option value="{{$service->id}}" {{in_array($service->id,$ads->services->pluck('service_id')->toArray()) ? 'selected' : ''}}>{{$service->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-12">
                                            <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت  شروع انتشار</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_up" id="publish_up"  value="{{\Modules\Core\app\Http\Controllers\Helpers\Str::convertToJalali($ads->publish_up)}}" />
                                        </div>

                                        <div class="col-md-12">
                                            <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان انتشار</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_down" id="publish_down" value="{{\Modules\Core\app\Http\Controllers\Helpers\Str::convertToJalali($ads->publish_down)}}" />
                                        </div>

                                    </div>

                                </div>

                            </div>


                          </div>

                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.ads.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>




@endsection
