<?php

namespace Modules\Album\app\Models;


use Modules\File\app\Models\File;
use Modules\Tag\app\Models\Tag;
use Modules\Comment\app\Models\Comment;
use Modules\Field\app\Models\FieldModel;
use Illuminate\Database\Eloquent\Model;
use Modules\Category\app\Models\Category;
use Illuminate\Database\Eloquent\SoftDeletes;

class Album extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'body',
        'link',
        'image',
        'state',
        'view_count',
        'comment_count',
        'publish_up',
        'publish_down',
        'main_cat' ,
    ];



    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query->where('state',1)
            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);
            });
    }


    public function category()
    {
        return $this->belongsTo(Category::class, 'main_cat');
    }



    public function comments()
    {
        return $this->morphMany(Comment::class, 'comment','commentable_type','commentable_id');
    }

    public function commentsActive()
    {
        return $this->morphMany(Comment::class, 'comment','commentable_type','commentable_id')->where('state','=',1);
    }

    public function categories()
    {
        return $this->morphToMany(Category::class, 'catgable');
    }


    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable');
    }

    public function sounds()
    {
        return $this->morphMany(File::class, 'gallerytable','file_type','file_id');
    }


    public function fields()
    {
        return $this->morphMany(FieldModel::class, 'fieldModel','model_type','model_id');
    }



    public function getSlugAttribute(){
        return str_replace(' ','-',$this->title);
    }

    public function getImageAttribute($value){
        return $value;
    }


    public function getRouteAttribute(){
        return "/show/album/{$this->id}/{$this->slug}";
    }
}
