@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
        @endsection

    @section('script')


        <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

        <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

        <script>
            var options = {
                filebrowserImageBrowseUrl: '/file-manager/ckeditor',
                filebrowserImageUploadUrl: '/file-manager/ckeditor',
                filebrowserBrowseUrl: '/file-manager/ckeditor',
                filebrowserUploadUrl: '/file-manager/ckeditor',

            };
            CKEDITOR.replace('body' ,options);
            $('#submit').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) {
                    e.preventDefault();
                    return false;
                }
            });
        </script>

        <script>
            const tag1 = document.querySelector("#tag");
            const tag = new Tagify(tag1, {
                whitelist: [{!!  \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],
                dropdown: {
                    classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted
                    enabled: 0,             // <- show suggestions on focus
                    closeOnSelect: false    // <- do not hide the suggestions dropdown once an item has been selected
                }
            });
        </script>

    @endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>

                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#publish" role="tab" aria-selected="true">
                                انتشار
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#gallery" role="tab"
                                aria-selected="true">
                                گالری
                            </button>
                        </li>

                        @foreach($field_groups->where('type','albums') as $group)

                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#{{$group->name}}" role="tab" aria-selected="true">
                                    {{$group->title}}
                                </button>
                            </li>

                        @endforeach


                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formData" action="{{route('admin.album.store')}}" method="post">
                        {{ csrf_field() }}

                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-12">

                                    <div class="row">


                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>


                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select required id="state" name="state" class="form-select" >
                                                    <option value="1" {{'1' == old('state') ? 'selected' : ''}}>فعال</option>
                                                    <option value="0" {{'0' == old('state') ? 'selected' : ''}}>غیر فعال</option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <label class="form-label" for="title">کاور آلبوم</label>
                                            <div class="input-group">
                                                <input type="text" id="image1" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="link">لینک</label>
                                            <input type="text" id="link"  name="link" class="form-control" placeholder="لینک" value="{{old('link')}}">
                                            @if($errors->has('link'))
                                                <div data-field="link" class="text-danger">{{ $errors->first('link') }}</div>
                                            @endif
                                        </div>




                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">متن خبر</label>
                                            <textarea  type="text" id="body"  name="body" class="form-control" >{{old('body')}}</textarea>
                                            @if($errors->has('body'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('body') }}</div>
                                            @endif
                                        </div>

                                    </div>

                                </div>





                            </div>


                          </div>

                        <div class="tab-pane fade " id="publish" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-5">

                                    <div class="row">

                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی اصلی</label>
                                            <select id="selectpickerSelectDeselect" required name="main_cat" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category])
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی فرعی</label>
                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category])
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="col-md-12">
                                                <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت  شروع انتشار</label>
                                                <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_up" id="publish_up"  value="{{old('publish_up')}}" />
                                        </div>

                                        <div class="col-md-12">
                                            <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان انتشار</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_down" id="publish_down" value="{{old('publish_down')}}" />
                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-6">

                                    <div class="row">



                                        <div class="col-md-12">
                                            <label for="tag" class="form-label">تگ</label>
                                            <input id="tag" class="form-control" name="tag" value="{{old('tag')}}" />
                                        </div>


                                    </div>

                                </div>





                            </div>


                        </div>
                        <div class="tab-pane fade " id="gallery" role="tabpanel">
                            <div class="col-md-12">

                                <div class="form-list">
                                    <div class="form-row" style="padding-top: 50px;" id="someId">
                                        <div class="row">
                                            <div class="form-group col-md-4">
                                                <div class="input-group">
                                                    <input type="text" id="image" class="form-control new-image"
                                                        name="image" aria-label="Image"
                                                        aria-describedby="button-image">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-outline-secondary" type="button"
                                                            id="button-image">آپلود</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <button type="button" class="btn btn-success"
                                                    onclick="addFormElements(this)">اضافه کردن</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>


                        @foreach($field_groups->where('type','albums') as $group)

                            <div class="tab-pane fade " id="{{$group->name}}" role="tabpanel">


                                <div class="row g-3">

                                    <div class="col-md-12">

                                        <div class="row">

                                            @foreach($group->fields as $field)



                                                @if($field->type == 'string')
                                                    <div class="col-md-6">
                                                        <label for="{{$field->name}}" class="form-label">{{$field->title}}</label>
                                                        <input type="text" class="form-control" name="fields[{{$field->name}}]" id="{{$field->name}}" value="{{isset($album) && $album->fields->where('field_id',$field->id)->first() != null ? $album->fields->where('field_id',$field->id)->first()->value->value : ''}}" />
                                                    </div>
                                                @endif


                                            @endforeach


                                        </div>

                                    </div>




                                </div>


                            </div>


                        @endforeach


                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.album.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>



    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
        integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>

    <script>
        function addFormElements(current) {
            let newForm = $(current).parents('.form-list').append($(current).parents('.form-row').clone())
            let eles = document.getElementsByClassName('new-image');
            var i = 0;
            for (let item of eles) {
                item.id = 'image' + i
                i++
            }
        }
    </script>

@endsection
