<?php

namespace Modules\Borhan\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;
use Illuminate\Console\View\Components\Alert;
use Illuminate\Http\Request;
//use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Modules\Category\app\Models\Category;
use Modules\Comment\app\Models\Comment;
use Modules\Contact\app\Models\Contact;
use Modules\Menu\app\Models\Menu;
use Modules\News\app\Models\News;
use Modules\Page\app\Models\Page;
use Modules\Portfolio\app\Models\Portfolio;
use Modules\Portfolio\app\Models\PortfolioCategory;
use Modules\Service\app\Models\ServiceModel;
use Modules\Site\app\Models\Site;

class BorhanController extends Controller
{
    use SEOToolsTrait;

    public function index()
    {

        $banner_home = ServiceModel::active("index_banner","ads","desc")->limit(4)->get();
        $first_items_index = Menu::where('name','first_items_index')->with(['itemsActive'])->first();

        $second_items_index = Menu::where('name','second_items_index')->with(['itemsActive'])->first();
                $portfolios =Portfolio::take(5)->get();
                $third_menu_index=Menu::where('name','third_menu_index')->with(['itemsActive'])->first();
                $fifth_items_index = Menu::where('name','fifth_items_index')->with(['itemsActive'])->first();
        $blogs = News::limit(6)->get();
                $data = compact('blogs','third_menu_index','banner_home' ,'second_items_index', 'portfolios', 'fifth_items_index','first_items_index');

//dd($blogs);

        return view('borhan::home',$data );
    }
    public function portfolio($slug = null)
    {
        // لیست دسته‌بندی‌ها برای منوی هدر
        $portfolio_categories = PortfolioCategory::where('state', 1)->get();

        // بررسی وجود دسته‌بندی
        $category = $slug ? PortfolioCategory::where('slug', $slug)->first() : null;

        // فیلتر پروژه‌ها
        $portfolios = Portfolio::where('state', 1);

        if ($category) {
            $portfolios = $portfolios->where('cat_id', $category->id);
        }

        // صفحه‌بندی پروژه‌ها
        $portfolios = $portfolios->paginate(6);

        return view('borhan::portfolios', compact('portfolio_categories', 'portfolios', 'category'));

//        $portfolio_categories = PortfolioCategory::where('state', 1)->get();
//        $category = PortfolioCategory::where('slug', $slug)->first();
//
//
//        $portfolios = Portfolio::where('state', 1);
//
//        if ($slug) {
//            $portfolios = $portfolios->where('cat_id', $category->id);
//        }
//        $portfolios = $portfolios->paginate(4);
////        dd($portfolios);
//
//        return view('borhan::portfolios', compact( 'category','portfolio_categories', 'portfolios'));
   }
    public function portfolio_detail( $id,$slug=null)
    {
        $portfolio = Portfolio::where('id', $id)->first();

        return view('borhan::portfolio',compact('portfolio'));
    }

    public function contact()
    {
        $site_setting = Site::with(['settings' => function ($query) {
            $query->where('state', 1);
        }])->where('state', 1)->first();
//        dd($site_setting->settings);
        return view('borhan::contact', compact( 'site_setting'));
    }


    public function page($id,$slug){
        $page = Page::where('id',$id)->first();
        return view('borhan::page', compact('page'));
    }

    public function blogs($id,$slug){
    $blog_category = Category::where('id',$id)->first();
//        dd($blog_category->id);

    if($blog_category){
        $blogs = News::select(['id','title','slug','title_little','lead','image1','cat_id','publish_down','publish_up','state','special'])
            ->where('cat_id',$blog_category->id)
            ->latest('id')->paginate(4);
//        dd($blogs);

    }
        return view('borhan::blogs',compact('blogs'));
    }

    public function blog($slug)
    {
        $blog = News::where('slug',$slug)->first();
        $comments=Comment::where('commentable_type','Modules\News\app\Models\News')->where('commentable_id',$blog->id)->where('state',1)->where('parent_id',null)->get();

        return view('borhan::blog',compact('blog','comments'));
    }


    public function skills($id,$slug=null){
//        dd('djdjdj');
//        $blog = News::where('id',$id)->first();
//        $comments=Comment::where('commentable_type','Modules\News\app\Models\News')->where('commentable_id',$id)->where('state',1)->where('parent_id',null)->get();

        return view('borhan::skills');
    }
    public function skill($id,$slug=null){
//        dd('djdjdj');
//        $blog = News::where('id',$id)->first();
//        $comments=Comment::where('commentable_type','Modules\News\app\Models\News')->where('commentable_id',$id)->where('state',1)->where('parent_id',null)->get();

        return view('borhan::skill');
    }

    public function addComment($id, Request $request)
    {
//        dd($request);

        $request->validate([
            'captcha' => 'required|captcha',

            'message' => 'required|max:2000'
        ]);

        $inputs['body'] = str_replace(PHP_EOL, '<br/>', $request->message);
        $inputs['name'] = $request->name;
        $inputs['email'] = $request->email;
        $inputs['commentable_id'] = $id;
        $inputs['commentable_type'] = News::class;
        Comment::create($inputs);

        session::flash('success', 'پیام شما با موفقیت ثبت شد');


        return redirect()->back();
    }
    public function addCollaboration(Request $request)
    {
//dd($request);

        $validated = $request->validate([
            'captcha' => 'required|captcha',
            'subject' => 'required|string',
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'phone' => 'required|string|max:20',
            'message' => 'required|string',
        ]);


        $inputs['question'] = str_replace(PHP_EOL, '<br/>', $request->message);
        $inputs['name'] = $request->name;
        $inputs['email'] = $request->email;
        $inputs['mobile'] = $request->phone;
           $inputs['subject_id'] = $request->subject;

        Contact::create($inputs);
        session::flash('success', 'پیام شما با موفقیت ثبت شد');


        return redirect()->back();
    }


}
