<?php

namespace Modules\Borhan\app\Providers;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\TwitterCard;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Modules\Menu\app\Models\Menu;
use Modules\Service\app\Models\ServiceModel;
use Modules\Site\app\Models\Setting;
use Modules\Site\app\Models\Site;

class   BorhanServiceProvider extends ServiceProvider
{
    protected string $moduleName = 'Borhan';

    protected string $moduleNameLower = 'borhan';

    /**
     * Boot the application events.
     */
    public function boot(): void
    {
        $this->registerCommands();
        $this->registerCommandSchedules();
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'database/migrations'));


        try{
            if(Schema::hasTable('sites'))
            {

                    $site_setting = Site::with(['settings' => function ($query) {$query->where('state', 1);}])->where('state', 1)->first();
////dd($site_setting);
// dd($site_setting->settings);
//                $settings=Setting::where('site_id',2)->pluck('value', 'key');
//                $logo= $settings['logo'] ?? 'Default Site Name';
//                $email = $settings['email'] ?? 'Default Email';
//                $phone = $settings['tel'] ?? 'Default Phone';
//                $address = $settings['address'] ?? 'Default Phone';

                $menu_contact =Menu::where('name','menu_contact')->with(['itemsActive'])->first();
                $socials = Menu::where('name','social')->with(['itemsActive'])->get();
//                    dd($socials);
                    $menu_footer_one = Menu::where('name','menu_footer_one')->with(['itemsActive'])->first();
                    $menu_footer_two = Menu::where('name','menu_footer_two')->with(['itemsActive'])->first();
                    $menu_footer_three = Menu::where('name','menu_footer_three')->with(['itemsActive'])->first();
                    $menu_top_header = Menu::where('name','menu_top_header')->with(['itemsActive'])->first();
//dd($menu_contact);
                $fourth_items_index = Menu::where('name','fourth_items_index')->with(['itemsActive'])->first();

                $menu_footer_left = Menu::where('name','menu_footer_left')->with(['itemsActive'])->first();
                    $data = compact( 'menu_contact','fourth_items_index','socials','menu_footer_left', 'menu_footer_one','menu_footer_three', 'menu_footer_two',  'menu_top_header', 'site_setting');

                SeoMeta::setTitleDefault($site_setting->title);
                SEOMeta::setDescription($site_setting->meta_desc);
                SEOMeta::addKeyword([$site_setting->meta_tag]);
                SEOMeta::setCanonical(config('app.url'));
                OpenGraph::setDescription($site_setting->meta_desc);
                OpenGraph::setTitle($site_setting->title);
                OpenGraph::setUrl(config('app.url'));
                OpenGraph::addProperty('type', 'website');
                TwitterCard::setTitle($site_setting->title);
                TwitterCard::setSite($site_setting->title);
                JsonLd::setTitle($site_setting->title);
                JsonLd::setDescription($site_setting->meta_desc);
                JsonLd::addImage($site_setting->logo);
                SeoMeta::setTitleSeparator('|');

                    view()->composer('*',function($view) use ($data){
                        $view->with($data);
                    });
                }


        }
        catch(\Exception $e){

        }
    }

    public function register(): void
    {
        $this->app->register(RouteServiceProvider::class);
    }
    protected function registerCommands(): void
    {
        // $this->commands([]);
    }

    protected function registerCommandSchedules(): void
    {
        // $this->app->booted(function () {
        //     $schedule = $this->app->make(Schedule::class);
        //     $schedule->command('inspire')->hourly();
        // });
    }

    public function registerTranslations(): void
    {
        $langPath = resource_path('lang/modules/'.$this->moduleNameLower);

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, $this->moduleNameLower);
            $this->loadJsonTranslationsFrom($langPath);
        } else {
            $this->loadTranslationsFrom(module_path($this->moduleName, 'lang'), $this->moduleNameLower);
            $this->loadJsonTranslationsFrom(module_path($this->moduleName, 'lang'));
        }
    }

    protected function registerConfig(): void
    {
        $this->publishes([module_path($this->moduleName, 'config/config.php') => config_path($this->moduleNameLower.'.php')], 'config');
        $this->mergeConfigFrom(module_path($this->moduleName, 'config/config.php'), $this->moduleNameLower);
    }

    public function registerViews(): void
    {
        $viewPath = resource_path('views/modules/'.$this->moduleNameLower);
        $sourcePath = module_path($this->moduleName, 'resources/views');

        $this->publishes([$sourcePath => $viewPath], ['views', $this->moduleNameLower.'-module-views']);

        $this->loadViewsFrom(array_merge($this->getPublishableViewPaths(), [$sourcePath]), $this->moduleNameLower);

        $componentNamespace = str_replace('/', '\\', config('modules.namespace').'\\'.$this->moduleName.'\\'.config('modules.paths.generator.component-class.path'));
        Blade::componentNamespace($componentNamespace, $this->moduleNameLower);
    }

    /**
     * Get the services provided by the provider.
     */
    public function provides(): array
    {
        return [];
    }

    private function getPublishableViewPaths(): array
    {
        $paths = [];
        foreach (config('view.paths') as $path) {
            if (is_dir($path.'/modules/'.$this->moduleNameLower)) {
                $paths[] = $path.'/modules/'.$this->moduleNameLower;
            }
        }

        return $paths;
    }
}
