
@extends('borhan::layouts.master')

@section('content')

    <!-- Start Breadcrumb section -->
    <div
        class="breadcrumb-section"
        style="
        background-image: url(assets/img/innerpage/breadcrumb-bg1.png),
          linear-gradient(180deg, #121212 0%, #121212 100%);
      ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="banner-wrapper">
                        <div class="banner-content">
                            <ul class="breadcrumb-list">
                                <li><a href="{{route('borhan.home')}}">خانه</a></li>
                                <li>وبلاگ</li>
                            </ul>
                            <h1>آخرین وبلاگ و مقاله خبری.</h1>
                        </div>
                        <div class="scroll-down-btn">
                            <a href="#blog-grid">
                                <svg
                                    height="29"
                                    viewbox="0 0 19 29"
                                    width="19"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M9.5 0V28M9.5 28C10 24.3333 12.4 17.1 18 17.5M9.5 28C8.5 24.1667 5.4 16.7 1 17.5"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb section -->
    <!-- Start Blog Grid Section -->
    <div class="blog-list-section scroll-margin pt-120 mb-120" id="blog-grid">
        <div class="container-fluid">  <!-- استفاده از container-fluid برای عرض کامل صفحه -->
            <div class="row">
                @foreach ($blogs as $blog)
                    <div class="col-md-4">  <!-- استفاده از col-md-4 برای سه ستون در هر ردیف -->
                        <div
                            class="blog-card2 style-2 border--top wow animate fadeInDown"
                            data-wow-delay="200ms"
                            data-wow-duration="1500ms">
                            <div class="row g-0 align-items-center">
                                <div class="col-lg-5">
                                    <div class="blog-card-img-wrap">
                                            <a class="card-img" href="{{ route('borhan.news', ['slug' => $blog->slug]) }}">
                                            <img alt="{{ $blog->title }}" src="{{ $blog->image1}}" />
                                        </a>
                                        <a class="date" href="#">
                                <span><strong>{{ \Carbon\Carbon::parse($blog->publish_up)->format('d') }}</strong>
                                    {{ \Carbon\Carbon::parse($blog->publish_up)->translatedFormat('F') }}</span>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="blog-card-content-wrap">
                                        <div class="blog-card-content">
                                            <div class="blog-meta">
                                                <ul class="category">
                                                    <li><a href="#">دسته‌بندی</a></li>
                                                </ul>

                                            </div>
                                            <h4>
                                                <a href="{{ route('borhan.news', ['slug' => $blog->slug]) }}">{{ $blog->title }}</a>
                                            </h4>
                                            <p>{{ $blog->lead }}</p>
                                        </div>
                                        <div class="button-area">
                                            <a class="read-more-btn" href="{{ route('borhan.news', ['slug' => $blog->slug]) }}">
                                                بیشتر بخوانید
                                                <svg
                                                    height="10"
                                                    viewbox="0 0 10 10"
                                                    width="10"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        transform="scale(-1, 1) translate(-10, 0)"
                                                        clip-rule="evenodd"
                                                        d="M8.48878 0.885308L0 9.37364L0.626356 10L9.11469 1.51122V7.38037H10V0H2.61963V0.885308H8.48878Z"
                                                        fill-rule="evenodd"></path>
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div
                    class="col-lg-12 d-flex justify-content-center wow animate fadeInUp"
                    data-wow-delay="400ms"
                    data-wow-duration="1500ms">
                    <div class="pagination-area">
                        <ul class="paginations">
                            @if ($blogs->onFirstPage())
                                <li class="page-item disabled"><span>قبلی</span></li>
                            @else
                                <li class="page-item"><a href="{{ $blogs->previousPageUrl() }}">قبلی</a></li>
                            @endif

                            @foreach ($blogs->getUrlRange(1, $blogs->lastPage()) as $page => $url)
                                <li class="page-item {{ $blogs->currentPage() == $page ? 'active' : '' }}">
                                    <a href="{{ $url }}">{{ $page }}</a>
                                </li>
                            @endforeach

                            @if ($blogs->hasMorePages())
                                <li class="page-item"><a href="{{ $blogs->nextPageUrl() }}">بعدی</a></li>
                            @else
                                <li class="page-item disabled"><span>بعدی</span></li>
                            @endif
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Blog Grid Section -->
@endsection

