@extends('borhan::layouts.master')

@section('style')

@endsection

@section('content')

    <!-- Start Banner section -->
    <div class="home1-banner-section">
        <div class="container-fluid p-0">
            @if($first_items_index->itemsActive)
                @foreach($first_items_index->itemsActive as $item)
            <div class="row">


                    <div class="col-lg-6 d-flex align-items-xxl-start align-items-center">
                        <div class="banner-content">
                            <h1>{{$item->title}}</h1>
                            <p>{!!$item->desc  !!}</p>
                            <div class="banner-content-bottom">
                                <a
                                    class="primary-btn1"
                                    data-text="مشاوره رایگان"
                                    href="{{$item->link}}"
                                ><span>مشاوره رایگان</span></a
                                >

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="banner-img-wrap">
                            <div class="swiper banner-img-slider">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <img alt=""
                                             src="{{$item->image}}"/>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

            </div>
        </div>
        @endforeach
        @endif

    </div>
    <!-- Start Home1 Solution section -->
    <div class="home1-solution-section mb-110">
        <div class="container">
            <div class="row mb-60">
                <div class="col-lg-12 d-flex align-items-center justify-content-between flex-wrap gap-3">
                    <div class="section-title wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <h2>{{$third_menu_index->title}}</h2>
                    </div>

                </div>
            </div>
            <div class="row g-4">
                @if($third_menu_index->itemsActive)

                @foreach($third_menu_index->itemsActive as $item)
                <div class="col-lg-4 col-md-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                    <div class="service-card">
                        <div class="content">
                            <h4><a href="{{$item->lik}}">{{$item->title}}</a></h4>
                            <svg height="55" viewbox="0 0 55 55" width="55" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M4.60195 44.955V9.85566C4.60195 7.44701 6.55482 5.49414 8.96346 5.49414H5.69233C3.28368 5.49414 1.33081 7.44701 1.33081 9.85566V44.955C1.33081 47.4683 3.36862 49.5062 5.88205 49.5062H9.15319C6.63976 49.5062 4.60195 47.4683 4.60195 44.955Z"
                                    opacity="0.2"></path>
                                <path
                                    d="M49.3075 4.9491H5.69235C2.98679 4.9491 0.785645 7.15024 0.785645 9.8558V44.9548C0.785645 47.7649 3.07184 50.0511 5.88197 50.0511H49.1179C51.928 50.0511 54.2142 47.7649 54.2142 44.9548V9.8558C54.2142 7.15024 52.0131 4.9491 49.3075 4.9491ZM1.87602 9.8558C1.87602 7.75148 3.58803 6.03948 5.69235 6.03948H18.0335V10.0692C18.0335 11.2116 17.1041 12.1409 15.9618 12.1409H1.87602V9.8558ZM53.1238 44.9548C53.1238 47.1637 51.3268 48.9607 49.1179 48.9607H5.88197C3.67308 48.9607 1.87602 47.1637 1.87602 44.9548V13.2313H53.1238V44.9548ZM53.1238 12.141H18.3475C18.8305 11.5856 19.1239 10.8612 19.1239 10.0692V6.03948H49.3075C51.4118 6.03948 53.1238 7.75148 53.1238 9.8558V12.141Z">
                                </path>
                                <path
                                    d="M6.38621 7.78174C5.66471 7.78174 5.07776 8.36869 5.07776 9.09019C5.07776 9.8117 5.66471 10.3986 6.38621 10.3986C7.10771 10.3986 7.69466 9.8117 7.69466 9.09019C7.69466 8.36869 7.10771 7.78174 6.38621 7.78174ZM6.38621 9.30827C6.26594 9.30827 6.16813 9.21046 6.16813 9.09019C6.16813 8.96992 6.26594 8.87212 6.38621 8.87212C6.50648 8.87212 6.60429 8.96992 6.60429 9.09019C6.60429 9.21046 6.50648 9.30827 6.38621 9.30827ZM9.95469 7.78174C9.23319 7.78174 8.64624 8.36869 8.64624 9.09019C8.64624 9.8117 9.23319 10.3986 9.95469 10.3986C10.6762 10.3986 11.2631 9.8117 11.2631 9.09019C11.2631 8.36869 10.6762 7.78174 9.95469 7.78174ZM9.95469 9.30827C9.83443 9.30827 9.73662 9.21046 9.73662 9.09019C9.73662 8.96992 9.83443 8.87212 9.95469 8.87212C10.075 8.87212 10.1728 8.96992 10.1728 9.09019C10.1728 9.21046 10.075 9.30827 9.95469 9.30827ZM13.5232 7.78174C12.8017 7.78174 12.2147 8.36869 12.2147 9.09019C12.2147 9.8117 12.8017 10.3986 13.5232 10.3986C14.2447 10.3986 14.8316 9.8117 14.8316 9.09019C14.8316 8.36869 14.2447 7.78174 13.5232 7.78174ZM13.5232 9.30827C13.4029 9.30827 13.3051 9.21046 13.3051 9.09019C13.3051 8.96992 13.4029 8.87212 13.5232 8.87212C13.6434 8.87212 13.7413 8.96992 13.7413 9.09019C13.7413 9.21046 13.6434 9.30827 13.5232 9.30827ZM4.20022 17.2216C4.34481 17.2216 4.48348 17.1641 4.58573 17.0619C4.68797 16.9597 4.74541 16.821 4.74541 16.6764V15.6966C4.74541 15.552 4.68797 15.4133 4.58573 15.3111C4.48348 15.2088 4.34481 15.1514 4.20022 15.1514C4.05563 15.1514 3.91695 15.2088 3.81471 15.3111C3.71247 15.4133 3.65503 15.552 3.65503 15.6966V16.6764C3.65503 16.821 3.71247 16.9597 3.81471 17.0619C3.91695 17.1641 4.05563 17.2216 4.20022 17.2216ZM4.20022 27.8029C4.34481 27.8029 4.48348 27.7455 4.58573 27.6433C4.68797 27.541 4.74541 27.4024 4.74541 27.2578V19.1593C4.74541 19.0147 4.68797 18.876 4.58573 18.7738C4.48348 18.6715 4.34481 18.6141 4.20022 18.6141C4.05563 18.6141 3.91695 18.6715 3.81471 18.7738C3.71247 18.876 3.65503 19.0147 3.65503 19.1593V27.2578C3.65503 27.4024 3.71247 27.541 3.81471 27.6433C3.91695 27.7455 4.05563 27.8029 4.20022 27.8029Z">
                                </path>
                                <path
                                    d="M40.9903 30.5174C41.0731 29.7541 41.0934 28.9815 41.051 28.2163C41.0434 28.0783 40.9836 27.9485 40.8839 27.8529C40.7841 27.7573 40.6518 27.7032 40.5137 27.7014L34.8699 27.6287C34.1458 27.6434 34.357 28.4588 34.3567 28.9397C34.3567 31.8651 32.538 34.3721 29.9727 35.3942V30.6018C29.9727 29.9256 30.295 29.3091 30.8347 28.9526C31.723 28.3654 32.441 27.5546 32.9165 26.6019C34.406 23.6141 33.1871 19.9715 30.1994 18.4819C30.1163 18.4405 30.0239 18.421 29.9312 18.4253C29.8384 18.4295 29.7483 18.4574 29.6693 18.5063C29.5904 18.5551 29.5252 18.6234 29.48 18.7045C29.4348 18.7856 29.411 18.8769 29.411 18.9698V21.8363L27.5225 23.0939L25.5878 21.7403L25.5973 18.9683C25.5976 18.8318 25.5468 18.7001 25.4549 18.5991C25.3751 18.5114 25.2689 18.452 25.1523 18.4301C25.0357 18.4081 24.9152 18.4248 24.809 18.4776C23.4287 19.1632 22.3712 20.3358 21.8311 21.7794C20.8465 24.4128 21.7845 27.3486 24.1124 28.9185C24.6853 29.3048 25.0274 29.9344 25.0274 30.6025V35.4648C22.3673 34.4903 20.4637 31.9331 20.4637 28.9394C20.4748 28.4723 20.6307 27.7219 19.9502 27.7038L14.3074 27.701H14.3071C14.1669 27.701 14.0322 27.755 13.9308 27.8517C13.8294 27.9485 13.7691 28.0805 13.7626 28.2205C13.717 29.1915 13.772 30.1646 13.9268 31.1243L12.3707 32.6168C12.2902 32.6941 12.2353 32.7942 12.2134 32.9036C12.1916 33.013 12.2039 33.1265 12.2486 33.2288L14.0137 37.2633C14.0589 37.3666 14.1351 37.4534 14.2317 37.5116C14.3283 37.5698 14.4406 37.5967 14.5531 37.5884L16.7075 37.4301C17.4817 38.4277 18.4012 39.3036 19.4353 40.0286L19.3719 42.1804C19.3686 42.2932 19.4004 42.4042 19.4628 42.4982C19.5253 42.5922 19.6153 42.6645 19.7206 42.7051L23.8274 44.29C23.9322 44.3304 24.047 44.3374 24.156 44.3102C24.265 44.2829 24.3629 44.2227 24.4364 44.1377L25.8327 42.52C27.0867 42.6563 28.3496 42.6237 29.5953 42.4226L31.0873 43.9787C31.1645 44.0592 31.2646 44.1141 31.3741 44.136C31.4835 44.1578 31.597 44.1455 31.6993 44.1008L35.7338 42.3355C35.8371 42.2903 35.9239 42.2141 35.9822 42.1175C36.0404 42.0209 36.0672 41.9086 36.059 41.7961L35.9007 39.6418C36.8983 38.8675 37.7741 37.948 38.499 36.914L40.6509 36.9774C40.7636 36.9803 40.8745 36.9484 40.9684 36.886C41.0623 36.8236 41.1346 36.7337 41.1756 36.6287L42.7606 32.522C42.8435 32.3072 42.7824 32.0634 42.6082 31.9129L40.9904 30.5171L40.9903 30.5174ZM24.7222 28.0148C22.8139 26.7279 22.0451 24.321 22.8526 22.1617C23.1809 21.2804 23.7536 20.5109 24.5037 19.9435L24.4966 22.0219C24.4963 22.1099 24.5173 22.1967 24.5578 22.2748C24.5983 22.3529 24.6572 22.4201 24.7293 22.4705L27.2026 24.201C27.2924 24.2639 27.3992 24.2982 27.5089 24.2994C27.6185 24.3007 27.726 24.2689 27.8173 24.208L30.2588 22.5823C30.3336 22.5325 30.3949 22.4651 30.4373 22.3859C30.4797 22.3067 30.5019 22.2183 30.5018 22.1285V19.9474C32.3641 21.361 33.0215 23.9482 31.941 26.1156C31.5513 26.8968 30.9625 27.5616 30.2341 28.0429C29.3879 28.6017 28.8827 29.5584 28.8827 30.602V35.7279C28.399 35.8331 27.9055 35.8862 27.4105 35.8863C26.9687 35.8863 26.5371 35.8432 26.118 35.7639V30.6028C26.118 29.5716 25.5963 28.6041 24.7224 28.0148H24.7222ZM40.2971 35.8764L38.2333 35.8157C38.0401 35.8091 37.8678 35.9018 37.7635 36.0583C37.0206 37.1739 36.0892 38.1519 35.0111 38.9483C34.9371 39.003 34.8781 39.0756 34.8397 39.1592C34.8013 39.2428 34.7847 39.3348 34.7915 39.4266L34.9432 41.4915L31.6108 42.9497L30.1818 41.4593C30.1194 41.3941 30.0418 41.3455 29.956 41.3178C29.8701 41.29 29.7788 41.284 29.6901 41.3003C28.3667 41.5428 27.0137 41.5778 25.6796 41.404C25.5902 41.3925 25.4992 41.4033 25.415 41.4355C25.3307 41.4677 25.2557 41.5202 25.1966 41.5884L23.8618 43.135L20.4731 41.8272L20.5339 39.7632C20.5366 39.6707 20.5158 39.5791 20.4734 39.497C20.4309 39.4148 20.3683 39.3448 20.2913 39.2935C19.1756 38.5506 18.1977 37.6191 17.4013 36.5409C17.3466 36.4669 17.274 36.4079 17.1904 36.3695C17.1067 36.3311 17.0147 36.3145 16.9229 36.3213L14.858 36.473L13.4 33.1405L14.8906 31.7111C14.9556 31.6487 15.0042 31.5711 15.0319 31.4853C15.0597 31.3995 15.0657 31.3082 15.0494 31.2195C14.9031 30.4187 14.8322 29.6059 14.8378 28.7919L19.3746 28.7942C19.3738 28.8427 19.3733 28.8912 19.3733 28.9397C19.3733 33.3713 22.9785 36.9766 27.4102 36.9766C31.8418 36.9766 35.447 33.3713 35.447 28.9395C35.447 28.8687 35.4461 28.7976 35.4442 28.7265L39.9806 28.7849C39.9907 29.4152 39.9551 30.0454 39.8741 30.6705C39.8624 30.76 39.8732 30.8509 39.9054 30.9352C39.9376 31.0195 39.9902 31.0945 40.0585 31.1534L41.6051 32.4877L40.2971 35.8762V35.8764Z">
                                </path>
                            </svg>
                            <p>
                           {!! $item->desc !!}
                            </p>
                        </div>
                        <a class="explore-btn" href="{{$item->lik}}">بیشتر کاوش کنید <svg height="9"
                                                                                                transform="scale(-1, 1) translate(0, 0)" viewbox="0 0 17 9" width="17"
                                                                                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M12.1691 4.97333L0.234337 4.95394C0.172187 4.95394 0.112583 4.9041 0.0686358 4.81538C0.024689 4.72666 0 4.60634 0 4.48087C0 4.35541 0.024689 4.23509 0.0686358 4.14637C0.112583 4.05765 0.172187 4.00781 0.234337 4.00781L12.1694 4.02721C12.2315 4.02721 12.2911 4.07705 12.3351 4.16576C12.379 4.25448 12.4037 4.37481 12.4037 4.50027C12.4037 4.62573 12.379 4.74606 12.3351 4.83478C12.2911 4.92349 12.2313 4.97333 12.1691 4.97333Z">
                                </path>
                                <path
                                    d="M16.9998 4.50591C14.3171 5.49934 10.9879 7.19858 8.9248 9L10.5521 4.50024L8.93094 0C10.9922 1.80378 14.3185 3.50681 16.9998 4.50591Z">
                                </path>
                            </svg>
                        </a>
                    </div>
                </div>
                    @endforeach
                @endif
            </div>
        </div>
    </div>
    <!-- End Home1 Solution section -->
    <!-- Start Portfolio section -->
    <div class="portfolio-section mb-110">
        <div class="container">
            <div class="row mb-60">
                <div class="col-lg-12 d-flex align-items-center justify-content-between flex-wrap gap-3">
                    <div class="section-title wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <h2>ویترین ما</h2>
                    </div>
                    <a class="primary-btn2 wow animate fadeInRight"
                       data-text="مشاهده تمام نمونه کارها"
                       data-wow-delay="200ms"
                       data-wow-duration="1500ms"
                       href="{{route('borhan.portfolios')}}"
                    ><span>مشاهده تمام نمونه کارها</span></a
                    >
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="swiper portfolio-slider">
                        <div class="swiper-wrapper">
                            {{--                            @dd($portfolios->itemsActive)--}}
                            @foreach($portfolios as $item)
                                <div class="swiper-slide">
                                    <a href="{{route('borhan.portfolio',$item->id)}}">

                                        <div class="eg-card">

                                            <div class="card-img">
                                                <img alt="{{$item->title}}" src="{{$item->image}}"/>
                                            </div>

                                            <div class="card-content">
                                                <a class="view-btn" href="{{route('borhan.portfolio',$item->id)}}">
                                                    <img alt="{{$item->title}}"
                                                         src="{{asset('modules/borhan/img/home1/right-arrow.png')}}"/>
                                                </a>
                                                <div class="catgory-and-title">
                                                    <h5>
                                                        <a href="{{route('borhan.portfolio',$item->id)}}">{{$item->title}}</a>
                                                    </h5>
                                                </div>
                                            </div>

                                        </div>
                                    </a>
                                </div>

                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="portfolio-bottom-area">
            <div class="container-fluid">
                <div class="pagination-area">
                    <div class="swiper-pagination pagination1"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Portfolio section -->
    <!-- Start Approach section -->
    <div class="home1-approach-section mb-110">
        <div class="container">
            <div class="row mb-60">
                <div class="col-lg-12 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                    <div class="section-title">
                        <h2>{{$fifth_items_index->title}}</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="approach-area h-100">
            <div class="container-fluid">
                <div class="row g-xl-4 gy-5">
                    @foreach($fifth_items_index->itemsActive as $item)
                        <div class="col-xl-3 col-lg-4 col-sm-6 wow animate fadeInUp" data-wow-delay="200ms"
                             data-wow-duration="1500ms">
                            <div
                                class="single-approach"
                                style="transition: transform 0.8s cubic-bezier(0.4,0,0.2,1), box-shadow 0.8s cubic-bezier(0.4,0,0.2,1); box-shadow: 0 1px 8px rgba(0,0,0,0.05);"
                                onmouseover="this.style.transform='translateY(-10px) scale(1.03)';this.style.boxShadow='0 8px 24px rgba(0,0,0,0.12)';"
                                onmouseout="this.style.transform='none';this.style.boxShadow='0 1px 8px rgba(0,0,0,0.05)';"
                            >
                                <a href="{{$item->lik}}">
                                    <div class="img-area">
                                        <img alt="" src="{{$item->image}}" />
                                    </div>
                                </a>
                                <div class="dot">
                                    <span></span>
                                </div>
                                <div class="approach-content-wrap">
                                    <div class="scroll-content-area">
                                        <div style="height: 100px" class="content scrollTextAni">
                                            <h5>{{$item->title}}</h5>
                                            <p>
                                                {{$item->desc}}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>


    <div class="home1-blog-section mb-110">
        <div class="container">
            <div class="row mb-60">
                <div class="col-lg-12 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                    <div class="section-title text-center">
                        <h2>خاطرات نوآوری</h2>
                    </div>
                </div>
            </div>


            <swiper-container class="mySwiper" pagination="true" pagination-clickable="true" space-between="30" slides-per-view="3">
                @foreach($blogs as $blog)
                    <swiper-slide>
                        <div class="row">
                            <div class="blog-card">
                                <div class="blog-card-img-wrap">
                                    <a class="card-img" href="{{  route('borhan.news', $blog->id)  }}">
                                        <img alt="{{ $blog->title }}" src="{{ $blog->image1}}" style="width:100%;height:350px;object-fit:cover;border-radius:40px;display:block;">
                                    </a>
                                    <a class="date" href="{{  route('borhan.news', $blog->id)  }}">
                                        <svg height="15" viewbox="0 0 15 15" width="15" xmlns="http://www.w3.org/2000/svg">
                                            <g>
                                                <path
                                                    d="M7.5 6.5625C7.62432 6.5625 7.74355 6.61189 7.83146 6.69979C7.91936 6.7877 7.96875 6.90693 7.96875 7.03125V8.4375H9.375C9.49932 8.4375 9.61855 8.48689 9.70646 8.57479C9.79436 8.6627 9.84375 8.78193 9.84375 8.90625C9.84375 9.03057 9.79436 9.1498 9.70646 9.23771C9.61855 9.32561 9.49932 9.375 9.375 9.375H7.96875V10.7812C7.96875 10.9056 7.91936 11.0248 7.83146 11.1127C7.74355 11.2006 7.62432 11.25 7.5 11.25C7.37568 11.25 7.25645 11.2006 7.16854 11.1127C7.08064 11.0248 7.03125 10.9056 7.03125 10.7812V9.375H5.625C5.50068 9.375 5.38145 9.32561 5.29354 9.23771C5.20564 9.1498 5.15625 9.03057 5.15625 8.90625C5.15625 8.78193 5.20564 8.6627 5.29354 8.57479C5.38145 8.48689 5.50068 8.4375 5.625 8.4375H7.03125V7.03125C7.03125 6.90693 7.08064 6.7877 7.16854 6.69979C7.25645 6.61189 7.37568 6.5625 7.5 6.5625Z">
                                                </path>
                                                <path
                                                    d="M3.28125 0C3.40557 0 3.5248 0.049386 3.61271 0.137294C3.70061 0.225201 3.75 0.34443 3.75 0.46875V0.9375H11.25V0.46875C11.25 0.34443 11.2994 0.225201 11.3873 0.137294C11.4752 0.049386 11.5944 0 11.7188 0C11.8431 0 11.9623 0.049386 12.0502 0.137294C12.1381 0.225201 12.1875 0.34443 12.1875 0.46875V0.9375H13.125C13.6223 0.9375 14.0992 1.13504 14.4508 1.48667C14.8025 1.83831 15 2.31522 15 2.8125V13.125C15 13.6223 14.8025 14.0992 14.4508 14.4508C14.0992 14.8025 13.6223 15 13.125 15H1.875C1.37772 15 0.900806 14.8025 0.549175 14.4508C0.197544 14.0992 0 13.6223 0 13.125V2.8125C0 2.31522 0.197544 1.83831 0.549175 1.48667C0.900806 1.13504 1.37772 0.9375 1.875 0.9375H2.8125V0.46875C2.8125 0.34443 2.86189 0.225201 2.94979 0.137294C3.0377 0.049386 3.15693 0 3.28125 0ZM0.9375 3.75V13.125C0.9375 13.3736 1.03627 13.6121 1.21209 13.7879C1.3879 13.9637 1.62636 14.0625 1.875 14.0625H13.125C13.3736 14.0625 13.6121 13.9637 13.7879 13.7879C13.9637 13.6121 14.0625 13.3736 14.0625 13.125V3.75H0.9375Z">
                                                </path>
                                            </g>
                                        </svg><span><strong>{{ \Carbon\Carbon::parse($blog->publish_up)->format('d') }}</strong>
                                    {{ \Carbon\Carbon::parse($blog->publish_up)->translatedFormat('F') }}</span></a>
                                </div>
                                <div class="card-content">

                                    <h4>
                                        <a href="{{ route('borhan.news', $blog->id) }}">{{ $blog->title }}</a>
                                    </h4>
                                    <a class="read-more-btn" href="{{ route('borhan.news', $blog->id) }}">ادامه مطلب<svg height="10" viewbox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                                            <path clip-rule="evenodd" transform="scale(-1, 1) translate(-10, 0)" transform="scale(-1, 1) translate(-12, 0)"
                                                  d="M8.48878 0.885308L0 9.37364L0.626356 10L9.11469 1.51122V7.38037H10V0H2.61963V0.885308H8.48878Z"
                                                  fill-rule="evenodd"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </swiper-slide>
                @endforeach
            </swiper-container>
        </div>
    </div>
    <!-- End Blog section -->
@endsection
