@extends('borhan::layouts.master')

@section('content')

    <!-- Start Breadcrumb section -->
    <div
        class="breadcrumb-section"
        style="
        background-image: url(assets/img/innerpage/breadcrumb-bg1.png),
          linear-gradient(180deg, #121212 0%, #121212 100%);
      "
    >
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="banner-wrapper">
                        <div class="banner-content">
                            <ul class="breadcrumb-list">
                                <li><a href="{{route('borhan.home')}}">خانه</a></li>
                                <li>جزئیات نمونه کارها</li>
                            </ul>
                            <h1>
                                {{$portfolio->title}}
                            </h1>
                        </div>
                        <div class="scroll-down-btn">
                            <a href="#portfolio-details-section">
                                <svg
                                    height="29"
                                    viewbox="0 0 19 29"
                                    width="19"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M9.5 0V28M9.5 28C10 24.3333 12.4 17.1 18 17.5M9.5 28C8.5 24.1667 5.4 16.7 1 17.5"
                                    ></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb section -->
    <!-- Start Case Study Details Section -->
    <div
        class="portfolio-details-page scroll-margin pt-120 mb-120"
        id="portfolio-details-section"
    >
        <div class="container">
            <div class="portfolio-details-thumb mb-80">
                <img alt="" src="{{$portfolio->image}}" />
            </div>
            <div class="row g-lg-4 gy-5 mb-80">
                <div class="col-lg-8">
                    <div class="portfolio-details-content">
                        <h3>{{$portfolio->led}}</h3>
                        <p> {!! $portfolio->body !!}</p>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Case Study Details Section -->
@endsection
