@extends('borhan::layouts.master')

@section('content')

    <!-- Start Breadcrumb section -->
    <div
        class="breadcrumb-section"
        style="
        background-image: url(assets/img/innerpage/breadcrumb-bg1.png),
          linear-gradient(180deg, #121212 0%, #121212 100%);
      "
    >
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="banner-wrapper">
                        <div class="banner-content">
                            <ul class="breadcrumb-list">
                                <li><a href="{{route('borhan.home')}}">خانه</a></li>
                                <li>نمونه کارها</li>
                            </ul>
                            <h1>نمونه کارهای گروه برهان</h1>
                        </div>
                        <div class="scroll-down-btn">
                            <a href="#portfolio-grid">
                                <svg
                                    height="29"
                                    viewbox="0 0 19 29"
                                    width="19"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M9.5 0V28M9.5 28C10 24.3333 12.4 17.1 18 17.5M9.5 28C8.5 24.1667 5.4 16.7 1 17.5"
                                    ></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb section -->
    <div class="portfolio-grid-section scroll-margin pt-120 mb-120" id="portfolio-grid">
        <div class="container">
            <div class="row g-4 mb-50">
                @foreach($portfolios as $portfolio)

                <div class="col-xl-4 col-md-6 wow animate fadeInDown" data-wow-delay="800ms" data-wow-duration="1500ms">


                    <div class="eg-card2">
                        <div class="card-img">


                            <img src="{{ $portfolio->image }}" alt="{{ $portfolio->title }}" class="card-img-top">

                        </div>

                        <div class="card-content">
                            <h5>
                                <a href="{{ route('borhan.portfolio', $portfolio->id) }}">{{$portfolio->title}}</a>
                            </h5>
                            <ul class="tag-list">
                                <li><a href="{{ route('borhan.portfolios',$portfolio->slug) }}"> دسته‌بندی: {{ $portfolio->category->title }}</a></li>
                            </ul>
                        </div>
                    </div>

                </div>
                    @endforeach
            </div>
            <div class="row">
                <div class="col-md-12">
                    {{ $portfolios->links() }}
                </div>
            </div>
        </div>
    </div>
    <!-- Start Team Section -->
@endsection
