@extends('borhan::layouts.master')

@section('content')
    <div class="pt-120 mb-120">
        <div class="container ">
            <div class="learning-laravel">
                <div class="container">
                    <div class="row">

                        <div class="col-md-6">
                            <h1>یادگیری لاراول</h1>
                            <p>لاراول پر استفاده‌ترین فریمورک زبان برنامه نویسی PHP بوده و در سال‌های اخیر توسط شرکت‌ها و
                                استارتاپ‌های بسیار زیادی مورد استفاده قرار گرفته است. یادگیری لاراول به شما کمک می‌کند با سرعت
                                بسیار زیادی وبسایت مورد نظرتان را توسعه دهید.</p>
                            <div class="mt-5 ">
                                <a href="#" class=" primary-btn1 p-3">
                                    مشاهده قدم ها
                                </a>

                                <a class="primary-btn1 p-2 me-2 mt-1" href="#">راهنمای انتخاب مسیر
                                    <svg class="ms-2" width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M12 24C2.118 24 0 21.882 0 12C0 2.118 2.118 0 12 0C21.882 0 24 2.118 24 12C24 21.882 21.882 24 12 24ZM14 6C13.4477 6 13 6.44772 13 7C13 7.55228 13.4477 8 14 8H17C17.5523 8 18 7.55228 18 7C18 6.44772 17.5523 6 17 6H14ZM6 12C6 11.4477 6.44772 11 7 11H17C17.5523 11 18 11.4477 18 12C18 12.5523 17.5523 13 17 13H7C6.44771 13 6 12.5523 6 12ZM7 16C6.44772 16 6 16.4477 6 17C6 17.5523 6.44772 18 7 18H10C10.5523 18 11 17.5523 11 17C11 16.4477 10.5523 16 10 16H7Z"
                                              fill="currentColor"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-6 mt-1">
                            <div class="vidue-card">
                                <video class="w-100" controls id="plyr-video-player" playsinline poster="https://cdn.plyr.io/static/demo/View_From_A_Blue_Moon_Trailer-HD.jpg">
                                    <source src="https://cdn.plyr.io/static/demo/View_From_A_Blue_Moon_Trailer-576p.mp4" type="video/mp4"/>
                                </video>
                            </div>
                        </div>

                    </div>

                </div>
            </div>


            <div class="container my-5">
                <div class="d-flex align-items-center">
                    <span class="me-3">نقشه راه:</span>
                    <div class="steps-items border  p-4 ">
                        <ul class="d-flex list-unstyled gap-4">
                            <li class="d-flex align-items-center">
                                <span class="ms-2">قدم‌های پیش‌نیاز:</span>
                                <span class="">
                            <div class="text-number">
                                <span class="text-success">1</span>
                            </div>
                        </span>
                            </li>
                            <li class="d-flex align-items-center">
                                <span class="ms-2">قدم‌های اصلی:</span>
                                <span class="">
                            <div class="text-number">
                                <span class="text-info">1</span>
                            </div>
                        </span>
                            </li>
                            <li class="d-flex align-items-center">
                                <span class="ms-2">قدم‌های بعدی:</span>
                                <span class="">
                            <div class="text-number">
                                <span class="text-warning-emphasis">1</span>
                            </div>
                        </span>
                            </li>
                        </ul>
                    </div>
                </div>

                <h2 class="mt-5 p-3">مسیر یادگیری چیه؟</h2>
                <p>بخش «مسیر یادگیری» در تلاش است تا از پیچیدگی فرایند آموزشی کاسته و مسیر روشنی را برای طی کردن دوره‌های آموزشی
                    در اختیار شما قرار دهد. هر کدام از مسیرهای یادگیری، از نقطه صفر شروع شده و شما را تا پیشرفته شدن همراهی
                    می‌کند. پیش رفتن با هر قدم از این مسیر می‌تواند دید بسیار خوبی به شما از فرایند آموزشی و میزان پیشرفت خودتان
                    را ارائه دهد.</p>
            </div>
            <div class="container my-5">
                <div class="prerequisite">
                    <div class="prerequisite-title">
                        <span class="p-3 mt-3">پیش نیاز ها</span>
                    </div>
                    <div class="prerequisite-items col-md-4">
                        <div class="prerequisite-item d-flex justify-content-between align-items-center">

                            <div class="logo">
                                <img width="48" height="48" src="https://img.icons8.com/parakeet/48/php.png" alt="php"/>
                                <span class="title">
                            یادگیری PHP</span>
                            </div>
                            <div class="text">
                                <img width="48" height="48" src="https://img.icons8.com/color-glass/48/education.png" alt="education"/>


                                <span class="title">
                            شامل 10دوره</span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="container">
                <div class="main-steps">
            <span>قدم‌های اصلی
            </span>
                    <div class="row">

                        <div class="col-md-4 my-2">
                            <div class="main-steps-item">
                                <a href="#" class="">
                                <div class="logo">
                                    <img class="w-full h-full object-cover rounded-lg hover:scale-110 transition duration-200 transform"
                                         src="./asset/img/lkvPWe3Hr9j4L39B6TJ3se2O1Rpa8YYouatjtA36.jpg" alt="">

                                    <span class="title">
                                یادگیری PHP</span>
                                </div>
                                </a>
                                <div class="d-flex justify-content-end">
                                    <span>تکمیل ضبط</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center border-top border-primary my-2">
                                    <div class="time">
                                <span><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="20" height="20"
                                           viewBox="0 0 48 48">
                                        <path
                                            d="M 24 4 C 12.972066 4 4 12.972074 4 24 C 4 35.027926 12.972066 44 24 44 C 35.027934 44 44 35.027926 44 24 C 44 12.972074 35.027934 4 24 4 z M 24 7 C 33.406615 7 41 14.593391 41 24 C 41 33.406609 33.406615 41 24 41 C 14.593385 41 7 33.406609 7 24 C 7 14.593391 14.593385 7 24 7 z M 23.476562 11.978516 A 1.50015 1.50015 0 0 0 22 13.5 L 22 25.5 A 1.50015 1.50015 0 0 0 23.5 27 L 31.5 27 A 1.50015 1.50015 0 1 0 31.5 24 L 25 24 L 25 13.5 A 1.50015 1.50015 0 0 0 23.476562 11.978516 z">
                                        </path>
                                    </svg>05:58:34</span>
                                    </div>
                                    <div class="range"><span>100تومان</span></div>

                                </div>



                            </div>

                        </div>



                    </div>

                </div>
            </div>
            <div class="container">
                <div class="titles-available">
                    <div class="row align-items-center ">

                        <div class="col-md-6">
                            <div class="top-title d-flex justify-content-between align-items-center mt-3 p-2 border">
                        <span>
                            سرفصل‌های قابل خریداری
                        </span>
                                <span>
                            20% تخفیف
                        </span>
                            </div>
                            <div class="items-title border-end border-start">

                                <div class="item col d-flex justify-content-between align-items-center p-3">
                                    <span>ساخت Api با Laravel و GraphQL</span>
                                    <span>
                                490,000
                                <svg class="mr-5px" width="15" height="17" viewBox="0 0 15 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.89875 6.65059C2.34542 6.65059 2.66542 6.54725 2.85875 6.34059C3.05208 6.14059 3.16542 5.89392 3.19875 5.60059H2.72875C2.38208 5.60059 2.09875 5.56392 1.87875 5.49059C1.65875 5.41725 1.48542 5.30725 1.35875 5.16059C1.23208 5.01392 1.14208 4.83725 1.08875 4.63059C1.04208 4.41725 1.01875 4.17392 1.01875 3.90059C1.01875 3.64059 1.05542 3.39392 1.12875 3.16059C1.20208 2.92059 1.30875 2.71392 1.44875 2.54059C1.59542 2.36725 1.77542 2.23059 1.98875 2.13059C2.20875 2.02392 2.46208 1.97059 2.74875 1.97059C2.97542 1.97059 3.18875 2.00725 3.38875 2.08059C3.59542 2.15392 3.77542 2.27059 3.92875 2.43059C4.08208 2.59059 4.20208 2.80059 4.28875 3.06059C4.38208 3.32059 4.42875 3.63725 4.42875 4.01059V4.23059H5.14875C5.29542 4.23059 5.36875 4.45059 5.36875 4.89059C5.36875 5.36392 5.29542 5.60059 5.14875 5.60059H4.41875C4.39875 5.92725 4.32875 6.23725 4.20875 6.53059C4.08875 6.82392 3.92208 7.08059 3.70875 7.30059C3.50208 7.52059 3.24875 7.69392 2.94875 7.82059C2.64875 7.95392 2.31542 8.02059 1.94875 8.02059H0.96875L0.90875 6.65059H1.89875ZM2.22875 3.80059C2.22875 3.96059 2.26208 4.07392 2.32875 4.14059C2.40208 4.20059 2.53542 4.23059 2.72875 4.23059H3.21875V3.95059C3.21875 3.69725 3.17542 3.52392 3.08875 3.43059C3.00875 3.33725 2.88208 3.29059 2.70875 3.29059C2.38875 3.29059 2.22875 3.46059 2.22875 3.80059ZM6.79648 4.23059C6.88315 4.23059 6.93982 4.28392 6.96648 4.39059C6.99982 4.49725 7.01648 4.66392 7.01648 4.89059C7.01648 5.13725 6.99982 5.31725 6.96648 5.43059C6.93982 5.54392 6.88315 5.60059 6.79648 5.60059H5.14648C5.05982 5.60059 5.00315 5.54725 4.97648 5.44059C4.94315 5.32725 4.92648 5.16059 4.92648 4.94059C4.92648 4.68725 4.94315 4.50725 4.97648 4.40059C5.00315 4.28725 5.05982 4.23059 5.14648 4.23059H6.79648ZM8.44688 4.23059C8.53354 4.23059 8.59021 4.28392 8.61688 4.39059C8.65021 4.49725 8.66688 4.66392 8.66688 4.89059C8.66688 5.13725 8.65021 5.31725 8.61688 5.43059C8.59021 5.54392 8.53354 5.60059 8.44688 5.60059H6.79688C6.71021 5.60059 6.65354 5.54725 6.62687 5.44059C6.59354 5.32725 6.57687 5.16059 6.57687 4.94059C6.57687 4.68725 6.59354 4.50725 6.62687 4.40059C6.65354 4.28725 6.71021 4.23059 6.79688 4.23059H8.44688ZM10.0973 4.23059C10.1839 4.23059 10.2406 4.28392 10.2673 4.39059C10.3006 4.49725 10.3173 4.66392 10.3173 4.89059C10.3173 5.13725 10.3006 5.31725 10.2673 5.43059C10.2406 5.54392 10.1839 5.60059 10.0973 5.60059H8.44727C8.3606 5.60059 8.30393 5.54725 8.27727 5.44059C8.24393 5.32725 8.22727 5.16059 8.22727 4.94059C8.22727 4.68725 8.24393 4.50725 8.27727 4.40059C8.30393 4.28725 8.3606 4.23059 8.44727 4.23059H10.0973ZM11.7477 4.23059C11.8343 4.23059 11.891 4.28392 11.9177 4.39059C11.951 4.49725 11.9677 4.66392 11.9677 4.89059C11.9677 5.13725 11.951 5.31725 11.9177 5.43059C11.891 5.54392 11.8343 5.60059 11.7477 5.60059H10.0977C10.011 5.60059 9.95432 5.54725 9.92766 5.44059C9.89432 5.32725 9.87766 5.16059 9.87766 4.94059C9.87766 4.68725 9.89432 4.50725 9.92766 4.40059C9.95432 4.28725 10.011 4.23059 10.0977 4.23059H11.7477ZM12.688 4.23059C12.8814 4.23059 13.018 4.18725 13.098 4.10059C13.1847 4.00725 13.228 3.86392 13.228 3.67059V2.63059H14.498V3.78059C14.498 4.38725 14.3514 4.84392 14.058 5.15059C13.7714 5.45059 13.3514 5.60059 12.798 5.60059H11.748C11.6614 5.60059 11.6047 5.54725 11.578 5.44059C11.5447 5.32725 11.528 5.16059 11.528 4.94059C11.528 4.68725 11.5447 4.50725 11.578 4.40059C11.6047 4.28725 11.6614 4.23059 11.748 4.23059H12.688ZM14.488 1.53059H13.278V0.370586H14.488V1.53059ZM12.948 1.53059H11.738V0.370586H12.948V1.53059ZM7.28883 13.3206C7.28883 13.7073 7.22883 14.0639 7.10883 14.3906C6.99549 14.7239 6.82883 15.0106 6.60883 15.2506C6.38883 15.4906 6.12216 15.6773 5.80883 15.8106C5.4955 15.9506 5.14549 16.0206 4.75883 16.0206H4.09883C3.35216 16.0206 2.77216 15.7906 2.35883 15.3306C1.94549 14.8706 1.73883 14.2406 1.73883 13.4406V11.6206H2.99883V13.3806C2.99883 13.5739 3.01883 13.7473 3.05883 13.9006C3.09883 14.0606 3.16549 14.1939 3.25883 14.3006C3.35883 14.4139 3.48883 14.5006 3.64883 14.5606C3.81549 14.6206 4.02216 14.6506 4.26883 14.6506H4.70883C4.96883 14.6506 5.18216 14.6139 5.34883 14.5406C5.52216 14.4739 5.65883 14.3773 5.75883 14.2506C5.85883 14.1306 5.92883 13.9906 5.96883 13.8306C6.00883 13.6706 6.02883 13.5006 6.02883 13.3206V10.6306H7.28883V13.3206ZM4.97883 10.5206H3.65883V9.31059H4.97883V10.5206ZM9.82297 13.6006C9.62964 13.6006 9.4463 13.5773 9.27297 13.5306C9.09964 13.4773 8.9463 13.3906 8.81297 13.2706C8.6863 13.1506 8.58297 12.9939 8.50297 12.8006C8.42964 12.6006 8.39297 12.3539 8.39297 12.0606V7.40059H9.66297V11.7306C9.66297 12.0639 9.80964 12.2306 10.103 12.2306H10.373C10.5196 12.2306 10.593 12.4506 10.593 12.8906C10.593 13.3639 10.5196 13.6006 10.373 13.6006H9.82297ZM10.4211 12.2306C10.6211 12.2306 10.7811 12.1973 10.9011 12.1306C11.0211 12.0573 11.0811 11.9239 11.0811 11.7306V11.6206C11.0811 11.3606 11.1211 11.1206 11.2011 10.9006C11.2811 10.6739 11.3944 10.4806 11.5411 10.3206C11.6878 10.1606 11.8678 10.0339 12.0811 9.94059C12.2944 9.84725 12.5311 9.80059 12.7911 9.80059C13.0644 9.80059 13.3078 9.84725 13.5211 9.94059C13.7344 10.0339 13.9111 10.1639 14.0511 10.3306C14.1978 10.4906 14.3078 10.6873 14.3811 10.9206C14.4611 11.1473 14.5011 11.3973 14.5011 11.6706C14.5011 12.2839 14.3444 12.7606 14.0311 13.1006C13.7244 13.4339 13.3111 13.6006 12.7911 13.6006C12.5311 13.6006 12.2778 13.5473 12.0311 13.4406C11.7911 13.3339 11.6144 13.1839 11.5011 12.9906C11.3744 13.2173 11.2111 13.3773 11.0111 13.4706C10.8111 13.5573 10.6144 13.6006 10.4211 13.6006H10.3711C10.2844 13.6006 10.2278 13.5473 10.2011 13.4406C10.1678 13.3273 10.1511 13.1606 10.1511 12.9406C10.1511 12.6873 10.1678 12.5073 10.2011 12.4006C10.2278 12.2873 10.2844 12.2306 10.3711 12.2306H10.4211ZM13.2811 11.7306C13.2811 11.5906 13.2478 11.4639 13.1811 11.3506C13.1144 11.2373 12.9844 11.1806 12.7911 11.1806C12.5978 11.1806 12.4678 11.2373 12.4011 11.3506C12.3344 11.4639 12.3011 11.5906 12.3011 11.7306C12.3011 12.0639 12.4644 12.2306 12.7911 12.2306C13.1178 12.2306 13.2811 12.0639 13.2811 11.7306Z"
                                        fill="currentColor"></path>
                                </svg>

                            </span>
                                </div>
                                <div class="item col d-flex justify-content-between align-items-center p-3">
                                    <span>ساخت Api با Laravel و GraphQL</span>
                                    <span>
                                490,000
                                <svg class="mr-5px" width="15" height="17" viewBox="0 0 15 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.89875 6.65059C2.34542 6.65059 2.66542 6.54725 2.85875 6.34059C3.05208 6.14059 3.16542 5.89392 3.19875 5.60059H2.72875C2.38208 5.60059 2.09875 5.56392 1.87875 5.49059C1.65875 5.41725 1.48542 5.30725 1.35875 5.16059C1.23208 5.01392 1.14208 4.83725 1.08875 4.63059C1.04208 4.41725 1.01875 4.17392 1.01875 3.90059C1.01875 3.64059 1.05542 3.39392 1.12875 3.16059C1.20208 2.92059 1.30875 2.71392 1.44875 2.54059C1.59542 2.36725 1.77542 2.23059 1.98875 2.13059C2.20875 2.02392 2.46208 1.97059 2.74875 1.97059C2.97542 1.97059 3.18875 2.00725 3.38875 2.08059C3.59542 2.15392 3.77542 2.27059 3.92875 2.43059C4.08208 2.59059 4.20208 2.80059 4.28875 3.06059C4.38208 3.32059 4.42875 3.63725 4.42875 4.01059V4.23059H5.14875C5.29542 4.23059 5.36875 4.45059 5.36875 4.89059C5.36875 5.36392 5.29542 5.60059 5.14875 5.60059H4.41875C4.39875 5.92725 4.32875 6.23725 4.20875 6.53059C4.08875 6.82392 3.92208 7.08059 3.70875 7.30059C3.50208 7.52059 3.24875 7.69392 2.94875 7.82059C2.64875 7.95392 2.31542 8.02059 1.94875 8.02059H0.96875L0.90875 6.65059H1.89875ZM2.22875 3.80059C2.22875 3.96059 2.26208 4.07392 2.32875 4.14059C2.40208 4.20059 2.53542 4.23059 2.72875 4.23059H3.21875V3.95059C3.21875 3.69725 3.17542 3.52392 3.08875 3.43059C3.00875 3.33725 2.88208 3.29059 2.70875 3.29059C2.38875 3.29059 2.22875 3.46059 2.22875 3.80059ZM6.79648 4.23059C6.88315 4.23059 6.93982 4.28392 6.96648 4.39059C6.99982 4.49725 7.01648 4.66392 7.01648 4.89059C7.01648 5.13725 6.99982 5.31725 6.96648 5.43059C6.93982 5.54392 6.88315 5.60059 6.79648 5.60059H5.14648C5.05982 5.60059 5.00315 5.54725 4.97648 5.44059C4.94315 5.32725 4.92648 5.16059 4.92648 4.94059C4.92648 4.68725 4.94315 4.50725 4.97648 4.40059C5.00315 4.28725 5.05982 4.23059 5.14648 4.23059H6.79648ZM8.44688 4.23059C8.53354 4.23059 8.59021 4.28392 8.61688 4.39059C8.65021 4.49725 8.66688 4.66392 8.66688 4.89059C8.66688 5.13725 8.65021 5.31725 8.61688 5.43059C8.59021 5.54392 8.53354 5.60059 8.44688 5.60059H6.79688C6.71021 5.60059 6.65354 5.54725 6.62687 5.44059C6.59354 5.32725 6.57687 5.16059 6.57687 4.94059C6.57687 4.68725 6.59354 4.50725 6.62687 4.40059C6.65354 4.28725 6.71021 4.23059 6.79688 4.23059H8.44688ZM10.0973 4.23059C10.1839 4.23059 10.2406 4.28392 10.2673 4.39059C10.3006 4.49725 10.3173 4.66392 10.3173 4.89059C10.3173 5.13725 10.3006 5.31725 10.2673 5.43059C10.2406 5.54392 10.1839 5.60059 10.0973 5.60059H8.44727C8.3606 5.60059 8.30393 5.54725 8.27727 5.44059C8.24393 5.32725 8.22727 5.16059 8.22727 4.94059C8.22727 4.68725 8.24393 4.50725 8.27727 4.40059C8.30393 4.28725 8.3606 4.23059 8.44727 4.23059H10.0973ZM11.7477 4.23059C11.8343 4.23059 11.891 4.28392 11.9177 4.39059C11.951 4.49725 11.9677 4.66392 11.9677 4.89059C11.9677 5.13725 11.951 5.31725 11.9177 5.43059C11.891 5.54392 11.8343 5.60059 11.7477 5.60059H10.0977C10.011 5.60059 9.95432 5.54725 9.92766 5.44059C9.89432 5.32725 9.87766 5.16059 9.87766 4.94059C9.87766 4.68725 9.89432 4.50725 9.92766 4.40059C9.95432 4.28725 10.011 4.23059 10.0977 4.23059H11.7477ZM12.688 4.23059C12.8814 4.23059 13.018 4.18725 13.098 4.10059C13.1847 4.00725 13.228 3.86392 13.228 3.67059V2.63059H14.498V3.78059C14.498 4.38725 14.3514 4.84392 14.058 5.15059C13.7714 5.45059 13.3514 5.60059 12.798 5.60059H11.748C11.6614 5.60059 11.6047 5.54725 11.578 5.44059C11.5447 5.32725 11.528 5.16059 11.528 4.94059C11.528 4.68725 11.5447 4.50725 11.578 4.40059C11.6047 4.28725 11.6614 4.23059 11.748 4.23059H12.688ZM14.488 1.53059H13.278V0.370586H14.488V1.53059ZM12.948 1.53059H11.738V0.370586H12.948V1.53059ZM7.28883 13.3206C7.28883 13.7073 7.22883 14.0639 7.10883 14.3906C6.99549 14.7239 6.82883 15.0106 6.60883 15.2506C6.38883 15.4906 6.12216 15.6773 5.80883 15.8106C5.4955 15.9506 5.14549 16.0206 4.75883 16.0206H4.09883C3.35216 16.0206 2.77216 15.7906 2.35883 15.3306C1.94549 14.8706 1.73883 14.2406 1.73883 13.4406V11.6206H2.99883V13.3806C2.99883 13.5739 3.01883 13.7473 3.05883 13.9006C3.09883 14.0606 3.16549 14.1939 3.25883 14.3006C3.35883 14.4139 3.48883 14.5006 3.64883 14.5606C3.81549 14.6206 4.02216 14.6506 4.26883 14.6506H4.70883C4.96883 14.6506 5.18216 14.6139 5.34883 14.5406C5.52216 14.4739 5.65883 14.3773 5.75883 14.2506C5.85883 14.1306 5.92883 13.9906 5.96883 13.8306C6.00883 13.6706 6.02883 13.5006 6.02883 13.3206V10.6306H7.28883V13.3206ZM4.97883 10.5206H3.65883V9.31059H4.97883V10.5206ZM9.82297 13.6006C9.62964 13.6006 9.4463 13.5773 9.27297 13.5306C9.09964 13.4773 8.9463 13.3906 8.81297 13.2706C8.6863 13.1506 8.58297 12.9939 8.50297 12.8006C8.42964 12.6006 8.39297 12.3539 8.39297 12.0606V7.40059H9.66297V11.7306C9.66297 12.0639 9.80964 12.2306 10.103 12.2306H10.373C10.5196 12.2306 10.593 12.4506 10.593 12.8906C10.593 13.3639 10.5196 13.6006 10.373 13.6006H9.82297ZM10.4211 12.2306C10.6211 12.2306 10.7811 12.1973 10.9011 12.1306C11.0211 12.0573 11.0811 11.9239 11.0811 11.7306V11.6206C11.0811 11.3606 11.1211 11.1206 11.2011 10.9006C11.2811 10.6739 11.3944 10.4806 11.5411 10.3206C11.6878 10.1606 11.8678 10.0339 12.0811 9.94059C12.2944 9.84725 12.5311 9.80059 12.7911 9.80059C13.0644 9.80059 13.3078 9.84725 13.5211 9.94059C13.7344 10.0339 13.9111 10.1639 14.0511 10.3306C14.1978 10.4906 14.3078 10.6873 14.3811 10.9206C14.4611 11.1473 14.5011 11.3973 14.5011 11.6706C14.5011 12.2839 14.3444 12.7606 14.0311 13.1006C13.7244 13.4339 13.3111 13.6006 12.7911 13.6006C12.5311 13.6006 12.2778 13.5473 12.0311 13.4406C11.7911 13.3339 11.6144 13.1839 11.5011 12.9906C11.3744 13.2173 11.2111 13.3773 11.0111 13.4706C10.8111 13.5573 10.6144 13.6006 10.4211 13.6006H10.3711C10.2844 13.6006 10.2278 13.5473 10.2011 13.4406C10.1678 13.3273 10.1511 13.1606 10.1511 12.9406C10.1511 12.6873 10.1678 12.5073 10.2011 12.4006C10.2278 12.2873 10.2844 12.2306 10.3711 12.2306H10.4211ZM13.2811 11.7306C13.2811 11.5906 13.2478 11.4639 13.1811 11.3506C13.1144 11.2373 12.9844 11.1806 12.7911 11.1806C12.5978 11.1806 12.4678 11.2373 12.4011 11.3506C12.3344 11.4639 12.3011 11.5906 12.3011 11.7306C12.3011 12.0639 12.4644 12.2306 12.7911 12.2306C13.1178 12.2306 13.2811 12.0639 13.2811 11.7306Z"
                                        fill="currentColor"></path>
                                </svg>

                            </span>
                                </div>
                                <div class="item col d-flex justify-content-between align-items-center p-3">
                                    <span>ساخت Api با Laravel و GraphQL</span>
                                    <span>490,000
                                <svg class="mr-5px" width="15" height="17" viewBox="0 0 15 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.89875 6.65059C2.34542 6.65059 2.66542 6.54725 2.85875 6.34059C3.05208 6.14059 3.16542 5.89392 3.19875 5.60059H2.72875C2.38208 5.60059 2.09875 5.56392 1.87875 5.49059C1.65875 5.41725 1.48542 5.30725 1.35875 5.16059C1.23208 5.01392 1.14208 4.83725 1.08875 4.63059C1.04208 4.41725 1.01875 4.17392 1.01875 3.90059C1.01875 3.64059 1.05542 3.39392 1.12875 3.16059C1.20208 2.92059 1.30875 2.71392 1.44875 2.54059C1.59542 2.36725 1.77542 2.23059 1.98875 2.13059C2.20875 2.02392 2.46208 1.97059 2.74875 1.97059C2.97542 1.97059 3.18875 2.00725 3.38875 2.08059C3.59542 2.15392 3.77542 2.27059 3.92875 2.43059C4.08208 2.59059 4.20208 2.80059 4.28875 3.06059C4.38208 3.32059 4.42875 3.63725 4.42875 4.01059V4.23059H5.14875C5.29542 4.23059 5.36875 4.45059 5.36875 4.89059C5.36875 5.36392 5.29542 5.60059 5.14875 5.60059H4.41875C4.39875 5.92725 4.32875 6.23725 4.20875 6.53059C4.08875 6.82392 3.92208 7.08059 3.70875 7.30059C3.50208 7.52059 3.24875 7.69392 2.94875 7.82059C2.64875 7.95392 2.31542 8.02059 1.94875 8.02059H0.96875L0.90875 6.65059H1.89875ZM2.22875 3.80059C2.22875 3.96059 2.26208 4.07392 2.32875 4.14059C2.40208 4.20059 2.53542 4.23059 2.72875 4.23059H3.21875V3.95059C3.21875 3.69725 3.17542 3.52392 3.08875 3.43059C3.00875 3.33725 2.88208 3.29059 2.70875 3.29059C2.38875 3.29059 2.22875 3.46059 2.22875 3.80059ZM6.79648 4.23059C6.88315 4.23059 6.93982 4.28392 6.96648 4.39059C6.99982 4.49725 7.01648 4.66392 7.01648 4.89059C7.01648 5.13725 6.99982 5.31725 6.96648 5.43059C6.93982 5.54392 6.88315 5.60059 6.79648 5.60059H5.14648C5.05982 5.60059 5.00315 5.54725 4.97648 5.44059C4.94315 5.32725 4.92648 5.16059 4.92648 4.94059C4.92648 4.68725 4.94315 4.50725 4.97648 4.40059C5.00315 4.28725 5.05982 4.23059 5.14648 4.23059H6.79648ZM8.44688 4.23059C8.53354 4.23059 8.59021 4.28392 8.61688 4.39059C8.65021 4.49725 8.66688 4.66392 8.66688 4.89059C8.66688 5.13725 8.65021 5.31725 8.61688 5.43059C8.59021 5.54392 8.53354 5.60059 8.44688 5.60059H6.79688C6.71021 5.60059 6.65354 5.54725 6.62687 5.44059C6.59354 5.32725 6.57687 5.16059 6.57687 4.94059C6.57687 4.68725 6.59354 4.50725 6.62687 4.40059C6.65354 4.28725 6.71021 4.23059 6.79688 4.23059H8.44688ZM10.0973 4.23059C10.1839 4.23059 10.2406 4.28392 10.2673 4.39059C10.3006 4.49725 10.3173 4.66392 10.3173 4.89059C10.3173 5.13725 10.3006 5.31725 10.2673 5.43059C10.2406 5.54392 10.1839 5.60059 10.0973 5.60059H8.44727C8.3606 5.60059 8.30393 5.54725 8.27727 5.44059C8.24393 5.32725 8.22727 5.16059 8.22727 4.94059C8.22727 4.68725 8.24393 4.50725 8.27727 4.40059C8.30393 4.28725 8.3606 4.23059 8.44727 4.23059H10.0973ZM11.7477 4.23059C11.8343 4.23059 11.891 4.28392 11.9177 4.39059C11.951 4.49725 11.9677 4.66392 11.9677 4.89059C11.9677 5.13725 11.951 5.31725 11.9177 5.43059C11.891 5.54392 11.8343 5.60059 11.7477 5.60059H10.0977C10.011 5.60059 9.95432 5.54725 9.92766 5.44059C9.89432 5.32725 9.87766 5.16059 9.87766 4.94059C9.87766 4.68725 9.89432 4.50725 9.92766 4.40059C9.95432 4.28725 10.011 4.23059 10.0977 4.23059H11.7477ZM12.688 4.23059C12.8814 4.23059 13.018 4.18725 13.098 4.10059C13.1847 4.00725 13.228 3.86392 13.228 3.67059V2.63059H14.498V3.78059C14.498 4.38725 14.3514 4.84392 14.058 5.15059C13.7714 5.45059 13.3514 5.60059 12.798 5.60059H11.748C11.6614 5.60059 11.6047 5.54725 11.578 5.44059C11.5447 5.32725 11.528 5.16059 11.528 4.94059C11.528 4.68725 11.5447 4.50725 11.578 4.40059C11.6047 4.28725 11.6614 4.23059 11.748 4.23059H12.688ZM14.488 1.53059H13.278V0.370586H14.488V1.53059ZM12.948 1.53059H11.738V0.370586H12.948V1.53059ZM7.28883 13.3206C7.28883 13.7073 7.22883 14.0639 7.10883 14.3906C6.99549 14.7239 6.82883 15.0106 6.60883 15.2506C6.38883 15.4906 6.12216 15.6773 5.80883 15.8106C5.4955 15.9506 5.14549 16.0206 4.75883 16.0206H4.09883C3.35216 16.0206 2.77216 15.7906 2.35883 15.3306C1.94549 14.8706 1.73883 14.2406 1.73883 13.4406V11.6206H2.99883V13.3806C2.99883 13.5739 3.01883 13.7473 3.05883 13.9006C3.09883 14.0606 3.16549 14.1939 3.25883 14.3006C3.35883 14.4139 3.48883 14.5006 3.64883 14.5606C3.81549 14.6206 4.02216 14.6506 4.26883 14.6506H4.70883C4.96883 14.6506 5.18216 14.6139 5.34883 14.5406C5.52216 14.4739 5.65883 14.3773 5.75883 14.2506C5.85883 14.1306 5.92883 13.9906 5.96883 13.8306C6.00883 13.6706 6.02883 13.5006 6.02883 13.3206V10.6306H7.28883V13.3206ZM4.97883 10.5206H3.65883V9.31059H4.97883V10.5206ZM9.82297 13.6006C9.62964 13.6006 9.4463 13.5773 9.27297 13.5306C9.09964 13.4773 8.9463 13.3906 8.81297 13.2706C8.6863 13.1506 8.58297 12.9939 8.50297 12.8006C8.42964 12.6006 8.39297 12.3539 8.39297 12.0606V7.40059H9.66297V11.7306C9.66297 12.0639 9.80964 12.2306 10.103 12.2306H10.373C10.5196 12.2306 10.593 12.4506 10.593 12.8906C10.593 13.3639 10.5196 13.6006 10.373 13.6006H9.82297ZM10.4211 12.2306C10.6211 12.2306 10.7811 12.1973 10.9011 12.1306C11.0211 12.0573 11.0811 11.9239 11.0811 11.7306V11.6206C11.0811 11.3606 11.1211 11.1206 11.2011 10.9006C11.2811 10.6739 11.3944 10.4806 11.5411 10.3206C11.6878 10.1606 11.8678 10.0339 12.0811 9.94059C12.2944 9.84725 12.5311 9.80059 12.7911 9.80059C13.0644 9.80059 13.3078 9.84725 13.5211 9.94059C13.7344 10.0339 13.9111 10.1639 14.0511 10.3306C14.1978 10.4906 14.3078 10.6873 14.3811 10.9206C14.4611 11.1473 14.5011 11.3973 14.5011 11.6706C14.5011 12.2839 14.3444 12.7606 14.0311 13.1006C13.7244 13.4339 13.3111 13.6006 12.7911 13.6006C12.5311 13.6006 12.2778 13.5473 12.0311 13.4406C11.7911 13.3339 11.6144 13.1839 11.5011 12.9906C11.3744 13.2173 11.2111 13.3773 11.0111 13.4706C10.8111 13.5573 10.6144 13.6006 10.4211 13.6006H10.3711C10.2844 13.6006 10.2278 13.5473 10.2011 13.4406C10.1678 13.3273 10.1511 13.1606 10.1511 12.9406C10.1511 12.6873 10.1678 12.5073 10.2011 12.4006C10.2278 12.2873 10.2844 12.2306 10.3711 12.2306H10.4211ZM13.2811 11.7306C13.2811 11.5906 13.2478 11.4639 13.1811 11.3506C13.1144 11.2373 12.9844 11.1806 12.7911 11.1806C12.5978 11.1806 12.4678 11.2373 12.4011 11.3506C12.3344 11.4639 12.3011 11.5906 12.3011 11.7306C12.3011 12.0639 12.4644 12.2306 12.7911 12.2306C13.1178 12.2306 13.2811 12.0639 13.2811 11.7306Z"
                                        fill="currentColor"></path>
                                </svg>

                            </span>
                                </div>

                            </div>
                            <div class="bottom-title d-flex justify-content-between align-items-center mb-3 p-2 border">
                                <div>
                            <span>
                                مبلغ قابل پرداخت:
                            </span>
                                </div>
                                <div class="price d-flex justify-content-between align-items-center">
                                    <div class="d-flex flex-column text-center me-3">
                                <span>
                                    20% تخفیف
                                </span>
                                        <span>
                                    20% تخفیف
                                </span>
                                    </div>
                                    <div class="border-end border-secondary mx-3" style="height: auto;"></div>
                                    <div class="d-flex flex-column text-center ms-3">
                                        <del>
                                            27000 تومان
                                        </del>
                                        <span>
                                    30000 تومان
                                </span>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-6 p-5 ">
                            <svg class="mb-5" width="94" height="94" viewBox="0 0 94 94" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M53.2438 26.3998L36.1218 6.99378C34.9117 5.62462 33.1716 4.83984 31.3443 4.83984C29.5162 4.83984 27.7768 5.62462 26.566 6.99378L9.43855 26.3998C8.41053 27.5647 7.84375 29.0647 7.84375 30.6182V79.9016C7.84375 86.8231 13.4542 92.4336 20.3757 92.4336H42.3067C49.2274 92.4336 54.8386 86.8231 54.8386 79.9016V30.6182C54.8386 29.0647 54.2711 27.5647 53.2438 26.3998ZM31.3412 32.9067C27.8801 32.9067 25.0752 30.1019 25.0752 26.6408C25.0752 23.1804 27.8801 20.3748 31.3412 20.3748C34.8016 20.3748 37.6072 23.1804 37.6072 26.6408C37.6072 30.1019 34.8016 32.9067 31.3412 32.9067Z"
                                    fill="#FFA826"></path>
                                <path
                                    d="M84.4874 61.1034L59.851 18.4194C59.0747 17.0747 57.8348 16.0597 56.3624 15.5656L38.3477 9.51074L53.25 26.3995C54.2757 27.5652 54.8402 29.0652 54.8387 30.6179V79.9014C54.8379 83.8329 52.9884 87.535 49.8447 89.8962C53.4412 91.3969 57.5326 91.1345 60.9089 89.1864L79.9011 78.2209C85.8933 74.7598 87.947 67.0971 84.4874 61.1034Z"
                                    fill="#98A3B8"></path>
                                <path
                                    d="M64.8393 27.0605L63.1459 24.1348C60.881 27.15 58.0632 29.707 54.8438 31.6705V35.3221C54.9516 35.2616 55.0594 35.2081 55.1681 35.1454C58.8571 33.0618 62.1347 30.322 64.8393 27.0605Z"
                                    fill="#7F8EAB"></path>
                                <path
                                    d="M54.8387 29.7734H54.7614C54.8058 30.0534 54.8318 30.3349 54.8387 30.6179V79.9013C54.8379 83.8329 52.9884 87.5349 49.8447 89.8962C53.4412 91.3969 57.5326 91.1345 60.9089 89.1863L62.9641 87.9985L54.8387 29.7734Z"
                                    fill="#7F8EAB"></path>
                                <path
                                    d="M53.2453 26.3998L36.1233 6.99378C34.9132 5.62462 33.1731 4.83984 31.3458 4.83984C29.5177 4.83984 27.7783 5.62462 26.5675 6.99378L20.043 14.3895C36.3413 16.4325 48.5703 30.287 48.5742 46.7123V90.744C52.4499 88.5089 54.8386 84.3762 54.8401 79.9016V30.6182C54.8401 29.0647 54.2726 27.5647 53.2453 26.3998Z"
                                    fill="#FFC46C"></path>
                                <path
                                    d="M53.2721 84.6013C32.5084 84.6013 15.6762 67.7691 15.6762 47.0054V19.3301L9.43855 26.4C8.41053 27.5649 7.84375 29.0648 7.84375 30.6183V79.9018C7.84375 86.8233 13.4542 92.4338 20.3757 92.4338H42.3067C47.4116 92.4322 52.0047 89.3336 53.9192 84.6013H53.2721Z"
                                    fill="#F09A19"></path>
                                <path
                                    d="M37.3202 34.2768C35.8799 34.0787 34.5275 33.4698 33.4246 32.5244C32.2375 32.9795 30.9333 33.0292 29.7148 32.6667C29.7837 32.8044 29.8258 32.9581 29.9045 33.0912C31.4328 35.4838 33.9638 37.0549 36.7863 37.3646C37.7691 37.5299 38.765 37.6109 39.7625 37.6071C42.1826 37.5742 44.5866 37.2055 46.9058 36.511C46.573 35.5075 46.1952 34.5254 45.7699 33.5662C43.0369 34.4053 40.1548 34.6478 37.3202 34.2768Z"
                                    fill="#FFAC0D"></path>
                                <path
                                    d="M54.7433 29.5645C54.3655 29.8023 53.9884 30.0341 53.5967 30.2659C53.0858 30.5626 52.5703 30.8365 52.0563 31.1011C50.0522 32.136 47.9465 32.9629 45.7734 33.5671C46.1987 34.5255 46.5773 35.5069 46.9093 36.512C49.1826 35.8534 51.3862 34.9745 53.4881 33.8861C53.9379 33.6543 54.3876 33.4164 54.8359 33.1564V30.6185C54.8336 30.2651 54.803 29.9125 54.7433 29.5645Z"
                                    fill="#F09A19"></path>
                                <path
                                    d="M31.3402 54.8373C33.0704 54.8373 34.4732 56.2401 34.4732 57.9703C34.4732 58.8354 35.1746 59.5368 36.0397 59.5368C36.9048 59.5368 37.6062 58.8354 37.6062 57.9703C37.5955 55.1218 35.6649 52.639 32.9067 51.9269V50.1378C32.9067 49.2727 32.2053 48.5713 31.3402 48.5713C30.4751 48.5713 29.7737 49.2727 29.7737 50.1378V51.9269C26.7218 52.7124 24.7308 55.6465 25.1285 58.7726C25.5263 61.8987 28.1889 64.2401 31.3402 64.2363C33.0704 64.2363 34.4732 65.6391 34.4732 67.3692C34.4732 69.1002 33.0704 70.5022 31.3402 70.5022C29.61 70.5022 28.2072 69.1002 28.2072 67.3692C28.2072 66.5042 27.5058 65.8027 26.6407 65.8027C25.7756 65.8027 25.0742 66.5042 25.0742 67.3692C25.0849 70.2177 27.0155 72.7013 29.7737 73.4134V75.2017C29.7737 76.0668 30.4751 76.7682 31.3402 76.7682C32.2053 76.7682 32.9067 76.0668 32.9067 75.2017V73.4134C35.9586 72.6279 37.9489 69.6937 37.5511 66.5676C37.1534 63.4415 34.4916 61.0994 31.3402 61.1033C29.61 61.1033 28.2072 59.7012 28.2072 57.9703C28.2072 56.2401 29.61 54.8373 31.3402 54.8373Z"
                                    fill="white"></path>
                                <path
                                    d="M36.0397 39.1729H26.6407C25.7756 39.1729 25.0742 39.8743 25.0742 40.7393C25.0742 41.6044 25.7756 42.3058 26.6407 42.3058H36.0397C36.9048 42.3058 37.6062 41.6044 37.6062 40.7393C37.6062 39.8743 36.9048 39.1729 36.0397 39.1729Z"
                                    fill="#052D25"></path>
                                <path
                                    d="M36.0397 83.0342H26.6407C25.7756 83.0342 25.0742 83.7356 25.0742 84.6007C25.0742 85.4658 25.7756 86.1672 26.6407 86.1672H36.0397C36.9048 86.1672 37.6062 85.4658 37.6062 84.6007C37.6062 83.7356 36.9048 83.0342 36.0397 83.0342Z"
                                    fill="#052D25"></path>
                                <path
                                    d="M85.8434 60.3202L62.8454 20.4862C64.2612 19.0811 65.5133 17.5192 66.5765 15.8318C69.1879 11.6028 69.6552 7.58785 67.8899 4.52829C64.3759 -1.55642 53.2804 -1.50135 42.6301 4.64685C41.2151 5.47446 39.8551 6.39156 38.5571 7.39204L37.2927 5.96322C35.7859 4.25369 33.6182 3.2731 31.3403 3.27004C29.0617 3.2731 26.894 4.25369 25.3872 5.96322L8.26279 25.3639C6.9816 26.8141 6.27484 28.6828 6.27637 30.618V79.9014C6.28555 87.6842 12.5921 93.9907 20.3748 93.9999H42.3058C50.0886 93.9915 56.3951 87.6842 56.4043 79.9014V30.618C56.4004 29.1088 55.9652 27.6311 55.1506 26.3606L55.1636 26.3529C57.0376 25.2729 58.8167 24.0361 60.4819 22.6554L83.1303 61.8867C86.157 67.1308 84.361 73.8358 79.1184 76.864L60.1262 87.8295C59.2894 88.306 58.3945 88.6701 57.4629 88.9141C56.701 89.1145 56.2069 89.8496 56.3086 90.6305C56.4104 91.4115 57.0766 91.9959 57.8637 91.9951C58.0006 91.9943 58.136 91.976 58.2683 91.9416C59.4631 91.6272 60.6119 91.1568 61.6843 90.5426L80.6765 79.5771C87.4213 75.6861 89.7344 67.065 85.8434 60.3202ZM53.2713 79.9014C53.2644 85.9548 48.3584 90.86 42.3058 90.8669H20.3748C14.3215 90.86 9.41625 85.9548 9.40936 79.9014V30.618C9.4086 29.4461 9.83694 28.3149 10.6125 27.4368L27.7369 8.03072C28.6494 6.99659 29.9612 6.40457 31.3403 6.40304C32.7186 6.40457 34.0304 6.99736 34.9429 8.03072L50.2209 25.3471C46.7284 26.9931 42.9116 27.8399 39.0504 27.8253C39.4573 25.562 38.8271 23.236 37.3325 21.489C35.8386 19.7412 33.6388 18.7576 31.3403 18.808C31.1682 18.8142 30.9976 18.8486 30.837 18.9098C30.0476 18.8126 29.3126 19.3297 29.1374 20.1053C28.5798 22.2462 28.8537 24.5179 29.9038 26.4654C30.9441 28.1879 32.5641 29.4844 34.4733 30.1215C33.6166 30.904 32.4999 31.3385 31.3403 31.34C28.7443 31.34 26.6408 29.2366 26.6408 26.6405C26.6408 25.7754 25.9394 25.074 25.0743 25.074C24.2092 25.074 23.5078 25.7754 23.5078 26.6405C23.5032 30.1131 25.7895 33.1727 29.1206 34.1533C32.4517 35.1339 36.0306 33.8007 37.9084 30.8795C38.5249 30.9453 39.1445 30.979 39.7648 30.9813C44.1385 30.8497 48.431 29.7689 52.345 27.8139C52.9416 28.6277 53.2651 29.6091 53.2713 30.618V79.9014ZM36.0398 26.6405C36.0337 26.87 36.01 27.0979 35.971 27.3236C34.588 26.9648 33.391 26.099 32.6169 24.8989C32.1335 24.0169 31.9262 23.0111 32.0218 22.0099C34.3219 22.3472 36.0299 24.316 36.0398 26.6405ZM53.5956 23.6391C53.4388 23.7301 53.282 23.8089 53.1252 23.8961L40.6406 9.74637C41.7772 8.87975 42.9659 8.0835 44.1997 7.36068C53.0234 2.26421 62.6328 1.68825 65.1783 6.10702C66.3417 8.12175 65.892 10.9947 63.9139 14.198C63.1315 15.441 62.2289 16.6044 61.2192 17.6714L61.2039 17.6431C60.2371 15.9672 58.6913 14.7021 56.8571 14.0871L50.7188 12.0189C50.1842 11.8223 49.5845 11.9317 49.1531 12.3049C48.7217 12.6782 48.5274 13.2557 48.646 13.8141C48.7638 14.3717 49.176 14.8214 49.7214 14.9874L55.8558 17.0488C56.9657 17.4228 57.9019 18.1885 58.4878 19.2027L58.8871 19.8942C57.2433 21.3039 55.4719 22.5583 53.5956 23.6391Z"
                                    fill="#4B5A78"></path>
                                <path
                                    d="M59.7519 63.1405C60.1849 63.8894 61.1425 64.1464 61.8921 63.7134L72.7444 57.4475C73.2331 57.1698 73.5353 56.6512 73.5368 56.089C73.5383 55.5276 73.2377 55.0075 72.7505 54.7275C72.2633 54.4476 71.6628 54.4506 71.1779 54.7344L60.3256 61.0004C59.576 61.4333 59.3198 62.3909 59.7519 63.1405Z"
                                    fill="#052D25"></path>
                                <path
                                    d="M61.7289 72.8511C62.161 73.6007 63.1194 73.8569 63.8683 73.4248L77.4344 65.5923C77.9231 65.3146 78.2253 64.796 78.2268 64.2338C78.2283 63.6716 77.9277 63.1523 77.4405 62.8723C76.9533 62.5924 76.3528 62.5947 75.8679 62.8792L62.3018 70.7117C61.5529 71.1438 61.2959 72.1023 61.7289 72.8511Z"
                                    fill="#052D25"></path>
                                <path
                                    d="M62.6153 54.0138C62.8907 54.0138 63.1607 53.9411 63.3986 53.8042L68.8247 50.6712C69.5743 50.2383 69.8313 49.2799 69.3991 48.5303C68.9662 47.7807 68.0078 47.5237 67.2582 47.9559L61.8321 51.0888C61.2163 51.443 60.9157 52.1666 61.0993 52.8527C61.2829 53.5388 61.9055 54.0153 62.6153 54.0138Z"
                                    fill="#052D25"></path>
                            </svg>
                            <h2>
                                شروع مسیر یادگیری لاراول
                            </h2>
                            <p>با خرید یک‌جای دوره‌های مسیر یادگیری لاراول از مزایای زیر برخورداری شوید.</p>
                            <div class="mt-6 col-md-6">
                                <div class="row">
                                    <div class="col-6 d-flex align-items-center mb-3">

                                        <span class="">تخفیف 20 درصدی</span>
                                    </div>
                                    <div class="col-6 d-flex align-items-center mb-3">

                                        <span class="">تخفیف 20 درصدی</span>
                                    </div>
                                    <div class="col-6 d-flex align-items-center mb-3">

                                        <span class="">تخفیف 20 درصدی</span>
                                    </div>
                                </div>

                            </div>
                            <div class="d-flex align-items-center">
                                <a href="#" class="primary-btn1 d-flex align-items-center">
                                    برای خرید ابتدا وارد سایت شوید
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container my-5">
                <div class="prerequisite">
                    <div class="prerequisite-title">
                        <span class="p-3 mt-3">گام های بعدی</span>
                    </div>
                    <div class="prerequisite-items col-md-4">
                        <div class="prerequisite-item d-flex justify-content-between align-items-center">

                            <div class="logo">
                                <img width="48" height="48" src="https://img.icons8.com/parakeet/48/php.png" alt="php"/>
                                <span class="title">
                            یادگیری PHP</span>
                            </div>
                            <div class="text">
                                <img width="48" height="48" src="https://img.icons8.com/color-glass/48/education.png" alt="education"/>


                                <span class="title">
                            شامل 10دوره</span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection


