<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Modules\Borhan\app\Http\Controllers\BorhanController;

Route::prefix('/')->group(function (){
        Route::get('/','BorhanController@index')->name('borhan.home');
        Route::get('/page/{id?}/{slug?}','BorhanController@page')->name('borhan.page');
        Route::get('/portfolios/{id?}/{slug?}','BorhanController@portfolio')->name('borhan.portfolios');
    Route::get('/portfolio/{id}/{slug?}','BorhanController@portfolio_detail')->name('borhan.portfolio');
        Route::get('/contact','BorhanController@contact')->name('borhan.contact');
        Route::get('/news/{id?}/{slug?}',[BorhanController::class,'blogs'])->name('borhan.newses');
        Route::get('n/{slug?}',[BorhanController::class,'blog'])->name('borhan.news');
    Route::get('show/skills/{id?}/{slug?}',[BorhanController::class,'skills'])->name('borhan.skills');
    Route::get('show/skill/{id?}/{slug?}',[BorhanController::class,'skill'])->name('borhan.skill');


    Route::post('/add-collaboration', [BorhanController::class, 'addCollaboration'])->name('borhan.add-collaboration');

    Route::post('/add-comment/blog/{news:slug}', [BorhanController::class, 'addComment'])->name('borhan.blog.add-comment');

});



