<?php

namespace Modules\Category\app\Http\Controllers\Dashboard\Frest;



use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Category\app\Models\Category;
use Modules\Category\app\Http\Requests\Dashboard\Frest\Category\CategoryStoreRequest;
use Modules\Category\app\Http\Requests\Dashboard\Frest\Category\CategoryUpdateRequest;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\News\app\Models\News;
use Modules\Role\app\Models\Role;


class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($type)
    {

        $this->authorize('category.access');


        $categories = Category::
        when(Request()->tran_id != null,function ($query){
            $query->where('tran_id',Request()->tran_id);
        })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })->
            when(Request()->q != null,function ($query){
                    return $query->where('title','LIKE','%'.Request()->q."%");
             })
             ->where('type',$type)->whereNull('parent_id')->with('children')->latest()->paginate(15);

        return view('category::Dashboard.Frest.category.index',compact('categories','type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($type)
    {
        $this->authorize('category.create');

        $trans = Category::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();

        $categories = Category::whereNull('parent_id')->whereType($type)->with('children')->get();

        $roles = Role::latest()->get();

        return view('category::Dashboard.Frest.category.create',compact('categories','type','roles','trans'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CategoryStoreRequest $request)
    {
        $this->authorize('category.create');

        $path = File::uploadByFileManager($request->image);

        $category = Category::create([
            'title' => $request->title,
            'slug' => str_replace(' ', '-', $request->slug),
            'label' => $request->title,
            'key' => $request->key,
            'image' => $path,
            'desc' => $request->desc,
            'type' => $request->type,
            'tran_id' => $request->tran_id,
            'lang' => $request->lang,
            'state' =>$request->state,
            'special' =>$request->special,
            'meta_desc' => $request->meta_desc,
            'meta_tag' => $request->meta_tag,
            'parent_id' => $request->parent_id,
        ]);




        $category->roles()->attach($request->roles);


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.category.list',$category->type);



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        $this->authorize('category.edit');

        if($category->tran_id != null){
            $tran = Category::find($category->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $category->translates->pluck('lang')->toArray();
        }

        $categories = Category::where('id','!=',$category->id)->whereType($category->type)->whereNull('parent_id')
           ->with(['children' => function($query) use ($category){
              return $query->where('id','!=',$category->id);
            }])->get();

        $roles = Role::latest()->get();


        return view('category::Dashboard.Frest.category.edit',compact('roles','category','categories','trans'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CategoryUpdateRequest $request,Category $category)
    {

        $this->authorize('category.edit');



        if($request->parent_id != null)
        {
            $parent = Category::find($request->parent_id);
        }

        $category->title = $request->title;
        $category->slug = str_replace(' ', '-', $request->slug);
        $category->key = $request->key;
        $category->image = $request->image != null ? File::uploadByFileManager($request->image) :  $category->image;
        $category->desc =  $request->desc;
        $category->lang =  $request->lang;
        $category->state = $request->state;
        $category->special = $request->special;
        $category->parent_id = $request->parent_id == null ? null : $parent->id ;
        $category->update();



        $category->roles()->sync($request->roles);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.category.list',$category->type);



    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        $this->authorize('category.delete');
        $category->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('category.delete');
            Category::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('category.edit');
            Category::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('category.edit');
            Category::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }




}
