<?php

namespace Modules\Category\app\Models;


use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Ads\app\Models\Ads;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Course\app\Models\Course;
use Modules\Field\app\Models\FieldGroup;
use Modules\Language\app\Models\Language;
use Modules\News\app\Models\News;
use Modules\Role\app\Models\Role;
use Modules\Site\app\Models\Site;


class Category extends Model
{

    use SoftDeletes;



    protected $fillable = [
        'id','title','slug','tran_id','lang',
        'key','image','type',
        'desc','parent_id',
        'state','special',
    ];


    public function categories()
    {
        return $this->morphedByMany(Category::class, 'catgable');
    }
    public function courses()
    {
        return $this->belongsToMany(Course::class, 'course_category');
    }
    public function translates(){
        return $this->hasMany(Category::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function childrenActive()
    {
        return $this->hasMany(Category::class, 'parent_id')->where('state','=',1);
    }
    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }
    public function news()
    {
        return $this->morphedByMany(News::class, 'catgable');
    }


    public function ads()
    {
        return $this->morphedByMany(Ads::class, 'catgable');
    }
    public function roles(){

        return $this->belongsToMany(Role::class,'category_role');

    }
    public function hasRole($roles)
    {
        foreach ($roles as $role)
        {
            if(in_array(trim($this->id), $role->categories->pluck('id')->toArray()))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

    }


    public function childrenCategory()
    {
        $array [] = $this->id;

        foreach ($this->children as $category)
        {
            if($category->state == 1)
            {
                array_push($array,$category->id);

                if(count($category->children) > 0)
                {

                    foreach ($category->childrenCategory() as $item)
                    {
                        array_push($array,$item);
                    }
                }
            }
        }

        return  $array;
    }


    public function getImageUrlAttribute($value){

        if($this->image == null){
            return null;
        }

        if(config('file-manager.diskList')[0] == 'public') {
            return config('app.APP_URL').'/storage'.$this->image;
        } else {
            return config('app.AWS_ENDPOINT').$this->image;
        }
    }


    public function getRouteAttribute()
    {
        return '/'.$this->type.'/'. $this->id .'/'.$this->slug;
    }

    public function fieldGroups()
    {
        return $this->hasMany(FieldGroup::class, 'field_group_id');
    }
}
