@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')

        @endsection

    @section('script')
        <script src="{{asset('modules/core/js/dashboards-analytics.js')}}"></script>
    @endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font"> ویرایش </h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{route('admin.category.update', $category->id)}}" method="post">
                            @csrf
                            @method('put')


                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{ $category->title ,  old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6 ">
                                            <span>*</span>
                                            <label class="form-label" for="slug">اسلاگ</label>
                                            <input type="text" id="slug"  name="slug" class="form-control" placeholder="اسلاگ" value="{{old('slug',$category->slug)}}">
                                            @if($errors->has('slug'))
                                                <div data-field="slug" class="text-danger">{{ $errors->first('slug') }}</div>
                                            @endif
                                        </div>



                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">توضیحات</label>
                                            <textarea type="text" id="desc"  name="desc" class="form-control" >{{$category->desc , old('desc')}}</textarea>
                                            @if($errors->has('desc'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('desc') }}</div>
                                            @endif
                                        </div>

                                    </div>

                                </div>

                                <div class="col-md-4">


                                    <div class="col-md-12">

                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="state">زبان</label>
                                            <div class="position-relative">
                                                <select id="lang" name="lang" class="form-select" >
                                                    @foreach($languages as $language)
                                                        @if(!in_array($language->name,$trans) || $language->name == $category->lang)
                                                            <option value="{{$language->name}}" {{$language->name == $category->lang ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label" for="key">کلید</label>
                                            <input type="text" id="key"  name="key" class="form-control" placeholder="کلید" value="{{$category->key ,old('key')}}">
                                            @if($errors->has('key'))
                                                <div data-field="key" class="text-danger">{{ $errors->first('key') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-12">

                                            <label class="form-label" for="title">تصویر</label>
                                            <div class="input-group">
                                                <input type="text" id="image1" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                </div>
                                            </div>


                                        </div>


                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسترسی به نقش های</label>
                                            <select id="selectpickerSelectDeselect" name="roles[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($roles as $role)
                                                    <option value="{{$role->id}}" {{in_array($role->id,$category->roles->pluck('id')->toArray()) ? 'selected' : ''}}>{{$role->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="parent_id">والد</label>
                                        <div class="position-relative"><select id="parent_id" name="parent_id" class="form-select">
                                                <option value="" >انتخاب</option>
                                                @foreach($categories as $parent)
                                                    @include('category::Dashboard.Frest.category.listCategoryParent',['row' => 0, 'item' => $parent,'category' => $category])
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="state">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="state" name="state" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{'1' == $category->state ? 'selected' : ''}}>فعال</option>
                                                <option value="0" {{'2' == $category->state ? 'selected' : ''}}>غیر فعال</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="special">ویژه</label>
                                        <div class="position-relative">
                                            <select id="special" name="special" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{'1' == $category->special ? 'selected' : ''}}>ویژه</option>
                                                <option value="0" {{'0' == $category->special ? 'selected' : ''}}>غیر ویژه</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>



                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{route('admin.category.list',$category->type)}}" class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="{{ asset('modules/core/js/slug-edit.js') }}"></script>


@endsection
