<?php

namespace Modules\Comment\app\Http\Controllers\Dashboard\Frest;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Comment\app\Models\Comment;
use Modules\Comment\app\Http\Requests\Dashboard\Frest\Comment\CommentUpdateRequest;
use Modules\News\app\Models\News;
use Modules\Product\app\Models\Product;

class CommentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('comment.access');
        $comments = Comment::whereNull('parent_id')->latest('id')->paginate(15);


        return view('comment::Dashboard.Frest.comment.index',compact('comments'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Comment $comment)
    {

        return view('comment::Dashboard.Frest.comment.edit' , compact('comment'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CommentUpdateRequest $request,Comment $comment)
    {
        $this->authorize('comment.access');



        if( $request->answer == null){
            $comment->name = $request->name;
            $comment->state = $request->state;
            $comment->body = $request->body;
            $comment->update();
        }


        if( $request->answer != null){

            if($comment->commentable_type == 'Modules\News\app\Models\News'){
                $item = News::find($comment->commentable_id);
            }

            if($comment->commentable_type == 'Modules\Product\app\Models\Product'){
                $item = Product::find($comment->commentable_id);
            }


            $item->comments()->create([
                'commentable_id' => $item->id,
                'name' => 'پاسخ مدیریت',
                'body' => $request->answer,
                'parent_id' => $comment->id,
                'state' => 1,
                'ip' => $request->ip(),
            ]);

        }







        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.comment.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Comment $comment)
    {
        $this->authorize('comment.access');
        $comment->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.comment.index');

    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if($items[0] == ""){
            session::flash('error','هیچ آیتمی انتخاب نشده');
            return redirect()->back();
        }


        if(isset($_GET['delete']))
        {
            Comment::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            Comment::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            Comment::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }


}
