<?php

namespace Modules\Comment\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends Model
{
    use SoftDeletes;
    protected $fillable = ['id' ,'commentable_id' , 'commentable_type','name','parent_id','body','email','state','read','ip',
        'user_agent','like','dislike','comment_type'];



    public function comment()
    {
        return $this->morphTo(Comment::class,'commentable_type','commentable_id');
    }

    public function responses()
    {
        return $this->hasMany(Comment::class,'parent_id');
    }

    public function responsesActive()
    {
        return $this->hasMany(Comment::class,'parent_id')->where('state','=',1);
    }

}
