<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCommentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('comments', function (Blueprint $table) {
              $table->id();

            $table->string('name');
            $table->string('email')->nullable();
            $table->ipAddress('ip')->nullable();
            $table->text('user-agent')->nullable();
            $table->text('body');
            $table->text('answer')->nullable();
            $table->boolean('read')->default(0);
            $table->boolean('state')->default(0);

            $table->integer('like')->default(0);
            $table->integer('dislike')->default(0);

            $table->integer('commentable_id')->nullable();
            $table->string('commentable_type')->nullable();

            $table->unsignedBigInteger('parent_id')->nullable();
            $table->foreign('parent_id')->references('id')->on('comments')->onDelete('set null');


            $table->unsignedBigInteger('admin_id')->nullable();
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('set null');


            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('comments');
    }
}
