<?php

namespace Modules\Competition\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Modules\Competition\app\Http\Requests\Dashboard\Frest\competitionCategory\competitionCategoryStorRequest;
use Modules\Competition\app\Http\Requests\Dashboard\Frest\competitionCategory\competitionCategoryUpdateRequest;
use Modules\Competition\app\Models\CompetitionCategory;
use Modules\Vehicle\app\Models\VehicleCategory;

class competitionCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $competitionCategories = CompetitionCategory::all();
//        dd($competitionCategories);
        return view('competition::Dashboard.Frest.competitionCategory.index', compact('competitionCategories'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('competition::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(competitionCategoryStorRequest $request)
    {
        $competitionCategory = CompetitionCategory::create([
            'title' => $request->title,
            'state' => $request->state,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.competitionCategory.index');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('competition::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        return view('competition::edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(competitionCategoryUpdateRequest $request, CompetitionCategory $competitionCategory)
    {
        $competitionCategory->title = $request->title;
        $competitionCategory->state = $request->state;
        $competitionCategory->update();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.competitionCategory.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(CompetitionCategory $competitionCategory)
    {
        $competitionCategory->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            CompetitionCategory::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            CompetitionCategory::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            CompetitionCategory::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
