<?php

namespace Modules\Competition\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Modules\Area\app\Models\City;
use Modules\Competition\app\Http\Requests\Dashboard\Frest\competition\competitionStorRequest;
use Modules\Competition\app\Models\Competition;
use Modules\Competition\app\Models\CompetitionCategory;
use Modules\Competition\app\Models\CompetitionMember;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Service\app\Models\Service;
use Modules\Service\app\Models\ServiceModel;
use Modules\User\app\Models\Education;
use Modules\User\app\Models\User;
use Modules\Vehicle\app\Models\VehicleBrand;
use Modules\Vehicle\app\Models\VehicleCategory;
use Modules\Vehicle\app\Models\VehicleGallery;
use Modules\Vehicle\app\Models\VehicleType;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Morilog\Jalali\Jalalian;
use Carbon\Carbon;
class competitionController extends Controller
{
    private function convertToJalali($value)
    {
        $carbonDate = Carbon::parse($value);
        return Jalalian::fromCarbon($carbonDate)->format('Y/m/d H:i:s');
    }
    public function index()
    {
        $query = Competition::
            when(!is_null(Request()->competition_start_date), function ($query) {
                $start_time = Jalalian::fromFormat('Y-m-d H:i', Request()->competition_start_date)->toCarbon()->toDateString();
                return $query->whereDate('competition_start_time', '>=', $start_time);
            })
            ->when(!is_null(Request()->competition_end_date), function ($query) {
                $end_time = Jalalian::fromFormat('Y-m-d H:i', Request()->competition_end_date)->toCarbon()->toDateString();
                return $query->whereDate('competition_end_time', '<=', $end_time);
            })
//            when(Request()->model_year != null,function ($query){
//                $query->where('model_year',Request()->model_year);
//            })->
//            when(!is_null(Request()->state),function ($query){
//                return $query->whereIn('state',Request()->state);
//            })
//            ->when(!is_null(Request()->categories),function ($query){
//                return $query->whereIn('category_id',Request()->categories);
//            })
//            ->when(!is_null(Request()->brands),function ($query){
//                return $query->whereIn('brand_id',Request()->brands);
//            })
//            ->when(!is_null(Request()->types),function ($query){
//                return $query->whereIn('type_id',Request()->types);
//            })
//            ->when(!is_null(Request()->users),function ($query){
//                return $query->whereIn('user_id',Request()->users);
//            })
            ->with('category', 'vehicleCategory', 'vehicleType', 'vehicleBrand')
            ->latest('id');

//        die();
        $competitions = $query->paginate(15);
        return view('competition::Dashboard.Frest.competition.index', compact('competitions'));
    }
    public function create()
    {
        $services = Service::where('model','competitions')->latest()->get();
        $competitionCategories = CompetitionCategory::where('state', 1)->get();
        $vehicle_categories = VehicleCategory::where('state', 1)->get();
        $vehicle_brands = VehicleBrand::where('state', 1)->get();
        $vehicle_types = VehicleType::where('state', 1)->get();
        $cities = City::where('status', 1)->get();
        return view('competition::Dashboard.Frest.competition.create', compact('competitionCategories', 'vehicle_categories', 'vehicle_brands', 'vehicle_types', 'services', 'cities'));
    }
    public function store(competitionStorRequest $request)
    {
        $path = File::uploadByFileManager($request->image);

        $competition = Competition::create([
            'title' => $request->title,
            'start_time' => Jalalian::fromFormat('Y-m-d H:i', $request->start_date_time)->toCarbon(),
            'end_time' => Jalalian::fromFormat('Y-m-d H:i', $request->end_date_time)->toCarbon(),
            'image' => $path == null ? $path : $path,
            'place' => $request->place,
            'lead' => $request->lead,
            'body' => $request->bodyy,
            'cat_id' => $request->competitionCategory,
            'category_vehicle_id' => $request->vehicle_category,
            'type_vehicle_id' => $request->vehicle_type,
            'brand_vehicle_id' => $request->vehicle_brand,
            'capacity' => $request->capacity,
            'status_pay' => $request->status_pay,
            'price' => str_replace(',', '', $request->price),
            'status' => $request->status,
            'competition_start_time' => Jalalian::fromFormat('Y-m-d H:i', $request->competitionStartTime)->toCarbon(),
            'competition_end_time' => Jalalian::fromFormat('Y-m-d H:i', $request->competitionEndTime)->toCarbon(),
            'gender' => $request->gender,
            'age_rating' => $request->age_rating,
            'city' => $request->city,
        ]);
        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $competition->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.competition.index');
    }
    public function show($id)
    {
        $gallery = competition::find($id);
        return Storage::disk('secret')->response($gallery->image);
    }
    public function edit($id)
    {
        $services = Service::where('model','competitions')->latest()->get();
        $competitionCategories = CompetitionCategory::where('state', 1)->get();
        $vehicle_categories = VehicleCategory::where('state', 1)->get();
        $vehicle_brands = VehicleBrand::where('state', 1)->get();
        $vehicle_types = VehicleType::where('state', 1)->get();
        $cities = City::where('status', 1)->get();
        $competition = Competition::with('category', 'vehicleCategory', 'vehicleType', 'vehicleBrand', 'services')->where('id', $id)->first();
//        dd($competition);
        return view('competition::Dashboard.Frest.competition.edit', compact('competitionCategories', 'vehicle_categories', 'vehicle_brands', 'vehicle_types', 'services', 'competition', 'cities'));
    }
    public function update(Request $request, Competition $competition)
    {
        $path = File::uploadByFileManager($request->image);

        $competition->title = $request->title;
        $competition->start_time = Jalalian::fromFormat('Y-m-d H:i', $request->start_date_time)->toCarbon();
        $competition->end_time = Jalalian::fromFormat('Y-m-d H:i', $request->end_date_time)->toCarbon();
        $competition->image = $path == null ? $path : $path;
        $competition->place = $request->place;
        $competition->lead = $request->lead;
        $competition->body = $request->bodyy;
        $competition->cat_id = $request->competitionCategory;
        $competition->category_vehicle_id = $request->vehicle_category;
        $competition->type_vehicle_id = $request->vehicle_type;
        $competition->brand_vehicle_id = $request->vehicle_brand;
        $competition->capacity = $request->capacity;
        $competition->status_pay = $request->status_pay;
        $competition->price = str_replace(',', '', $request->price);
        $competition->status = $request->status;
        $competition->competition_start_time = Jalalian::fromFormat('Y-m-d H:i', $request->competitionStartTime)->toCarbon();
        $competition->competition_end_time = Jalalian::fromFormat('Y-m-d H:i', $request->competitionEndTime)->toCarbon();
        $competition->gender = $request->gender;
        $competition->age_rating = $request->age_rating;
        $competition->city = $request->city;
        $competition->update();


        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $competition->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.competition.index');
    }
    public function destroy(Competition $competition)
    {
        $competition->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }
    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            Competition::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            Competition::whereIn('id',$items)->update([
                'status' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            Competition::whereIn('id',$items)->update([
                'status' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
    public function members($id)
    {
        $competition_members = CompetitionMember::with('competition.category', 'competition.vehicleCategory', 'competition.vehicleType', 'competition.vehicleBrand', 'invoiceItem', 'user.profile')->where('competition_id', $id)->where('status', 1)->get();

//        dd($competition_members);
        return view('competition::Dashboard.Frest.competitionMembers.index', compact('competition_members'));
    }
}
