<?php

namespace Modules\Competition\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Competition\Database\factories\CompetitionFactory;
use Modules\Service\app\Models\ServiceModel;
use Modules\Vehicle\app\Models\VehicleBrand;
use Modules\Vehicle\app\Models\VehicleCategory;
use Modules\Vehicle\app\Models\VehicleType;
use Morilog\Jalali\Jalalian;
use Carbon\Carbon;
class Competition extends Model
{
    use HasFactory;


    protected $table = 'competition';
    protected $fillable = [
        'title',
        'start_time',
        'end_time',
        'image',
        'place',
        'lead',
        'body',
        'cat_id',
        'category_vehicle_id',
        'type_vehicle_id',
        'brand_vehicle_id',
        'capacity',
        'status_pay',
        'price',
        'status',
        'competition_start_time',
        'competition_end_time',
        'gender',
        'age_rating',
        'city',
    ];

    public function category()
    {
        return $this->belongsTo(CompetitionCategory::class, 'cat_id');
    }

    public function vehicleCategory()
    {
        return $this->belongsTo(VehicleCategory::class, 'category_vehicle_id');
    }

    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class, 'type_vehicle_id');
    }

    public function vehicleBrand()
    {
        return $this->belongsTo(VehicleBrand::class, 'brand_vehicle_id');
    }

    public function scopeHasService($query,$service)
    {
        if($service){
            return $query->whereHas('services',function($query) use ($service){
                return $query->where('service_id',$service->id);
            });
        } else {
            return $query->whereHas('services',function($query){
                return $query->whereIn('service_id',[]);
            });
        }

    }

    public function services()
    {
        return $this->morphMany(ServiceModel::class, 'serviceModel','model_type','model_id');
    }

    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query->where('status',1)
            ->where(function($q) use ($date) {
                $q->whereRaw('start_time IS NULL OR start_time < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('end_time IS NULL OR end_time > ?', [$date]);
            });
    }

    public function members()
    {
        return $this->hasMany(CompetitionMember::class);
    }
}
