<?php

namespace Modules\Competition\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Invoice\app\Models\InvoiceItem;
use Modules\User\app\Models\User;
use Modules\Vehicle\app\Models\Vehicles;

class CompetitionMember extends Model
{
    use HasFactory;


    protected $table = 'competition_members';
    protected $fillable = [
        'user_id','vehicle_id',
        'competition_id','invoice_item_id','status','qr',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicles::class);
    }

    public function competition()
    {
        return $this->belongsTo(Competition::class);
    }

    public function invoiceItem()
    {
        return $this->belongsTo(InvoiceItem::class);
    }
}
