<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('competition', function (Blueprint $table) {
            $table->id();
            $table->string('title'); //
            $table->timestamp('start_time')->nullable(); //
            $table->timestamp('end_time')->nullable(); //
            $table->timestamp('competition_start_time')->nullable(); //
            $table->timestamp('competition_end_time')->nullable(); //
            $table->string('image');//
            $table->string('place');//
            $table->string('lead');//
            $table->string('body');//
            $table->string('gender');//
            $table->string('age_rating');//
            $table->string('city');//

            $table->unsignedBigInteger('cat_id')->unsigned(); //
            $table->foreign('cat_id')->references('id')->on('competition_category')->onDelete('cascade');

            $table->unsignedBigInteger('category_vehicle_id')->unsigned(); //
            $table->foreign('category_vehicle_id')->references('id')->on('vehicle_categories')->onDelete('cascade');

            $table->unsignedBigInteger('type_vehicle_id')->unsigned()->nullable(); //
            $table->foreign('type_vehicle_id')->references('id')->on('vehicle_types')->onDelete('cascade');

            $table->unsignedBigInteger('brand_vehicle_id')->unsigned()->nullable(); //
            $table->foreign('brand_vehicle_id')->references('id')->on('vehicle_brands')->onDelete('cascade');

            $table->string('capacity'); //

            $table->string('status_pay');

            $table->string('price')->nullable();

            $table->string('status')->default(0); //

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('competition');
    }
};
