@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />

    <style>
        option[data-lang="en"] {
            display: none;
        }
    </style>
@endsection

@section('script')



    <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

    <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

    <script>
        var options = {
            filebrowserImageBrowseUrl: '/file-manager/ckeditor',
        };
        CKEDITOR.replace('body' ,options);
        $('#submit').on('keyup keypress', function(e) {
            var keyCode = e.keyCode || e.which;
            if (keyCode === 13) {
                e.preventDefault();
                return false;
            }
        });




    </script>

{{--    <script>--}}
{{--        const tag1 = document.querySelector("#tag");--}}
{{--        const tag = new Tagify(tag1, {--}}
{{--            whitelist: [{!!  \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],--}}
{{--            dropdown: {--}}
{{--                classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted--}}
{{--                enabled: 0,             // <- show suggestions on focus--}}
{{--                closeOnSelect: false    // <- do not hide the suggestions dropdown once an item has been selected--}}
{{--            }--}}
{{--        });--}}
{{--    </script>--}}

@endsection

@section('content')

    @include('core::components.file_set_to_editor')

    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                    aria-selected="true">
                                 رویداد ها
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formData" enctype="multipart/form-data" action="{{ route('admin.competition.store') }}" method="post">
                        {{ csrf_field() }}
                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="title">عنوان</label>
                                                <input type="text" id="title" name="title" class="form-control" required>
                                                @if ($errors->has('title'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="lead">خلاصه</label>
                                                <textarea id="lead" rows="1" name="lead" class="form-control" required></textarea>
                                                @if ($errors->has('lead'))
                                                    <div data-field="lead" class="text-danger">{{ $errors->first('lead') }}
                                                    </div>
                                                @endif
                                            </div>

                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="place">مکان</label>
                                                <input type="text" id="place" name="place" class="form-control" required>
                                                @if ($errors->has('place'))
                                                    <div data-field="place" class="text-danger">{{ $errors->first('place') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-2">
                                                <div class="col-md-12">
                                                    <span>*</span>
                                                    <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت شروع ثبت نام</label>
                                                    <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="start_date_time" id="publish_up"  value="{{old('start_date_time')}}" required/>
                                                </div>
                                                @if ($errors->has('start_date_time'))
                                                    <div data-field="start_date_time" class="text-danger">{{ $errors->first('start_date_time') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-2">
                                                <div class="col-md-12">
                                                    <span>*</span>
                                                    <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان ثبت نام</label>
                                                    <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="end_date_time" id="publish_down"  value="{{old('end_date_time')}}" required/>
                                                </div>
                                                @if ($errors->has('end_date_time'))
                                                    <div data-field="end_date_time" class="text-danger">{{ $errors->first('end_date_time') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-2">
                                                <div class="col-md-12">
                                                    <span>*</span>
                                                    <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت شروع رویداد</label>
                                                    <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="competitionStartTime" id="competitionStartTime"  value="{{old('competitionStartTime')}}" required/>
                                                </div>
                                                @if ($errors->has('competitionStartTime'))
                                                    <div data-field="competitionStartTime" class="text-danger">{{ $errors->first('competitionStartTime') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-2">
                                                <div class="col-md-12">
                                                    <span>*</span>
                                                    <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان رویداد</label>
                                                    <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="competitionEndTime" id="competitionEndTime"  value="{{old('competitionEndTime')}}" required/>
                                                </div>
                                                @if ($errors->has('competitionEndTime'))
                                                    <div data-field="competitionEndTime" class="text-danger">{{ $errors->first('competitionEndTime') }}
                                                    </div>
                                                @endif
                                            </div>

                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="state">جنسیت</label>
                                                <div class="position-relative">
                                                    <select id="gender" name="gender" class="form-select">
                                                        <option value="مرد">مرد</option>
                                                        <option value="زن">زن</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="state">رده سنی</label>
                                                <div class="position-relative">
                                                    <select id="age_rating" name="age_rating" class="form-select">
                                                        <option value="کودکان">کودکان</option>
                                                        <option value="نوجوانان">نوجوانان</option>
                                                        <option value="بزرگسالان">بزرگسالان</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="competitionCategory">دسته بندی رویداد</label>
                                                <div class="position-relative">
                                                    <select id="competitionCategory" name="competitionCategory" class="form-select" required>
                                                        @foreach($competitionCategories as $competitionCategory)
                                                            <option value="{{ $competitionCategory->id }}">{{$competitionCategory->title}}</option>
                                                        @endforeach
                                                    </select>
                                                    @if ($errors->has('competitionCategory'))
                                                        <div data-field="competitionCategory" class="text-danger">{{ $errors->first('competitionCategory') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="vehicle_category">دسته بندی وسیله نقلیه</label>
                                                <div class="position-relative">
                                                    <select id="vehicle_category" name="vehicle_category" class="form-select" required>
                                                    @foreach($vehicle_categories as $vehicle_category)
                                                            <option value="{{ $vehicle_category->id }}">{{ $vehicle_category->title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @if ($errors->has('vehicle_category'))
                                                        <div data-field="vehicle_category" class="text-danger">{{ $errors->first('vehicle_category') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="vehicle_brand">برند وسیله نقلیه</label>
                                                <div class="position-relative">
                                                    <select id="vehicle_brand" name="vehicle_brand" class="form-select">
                                                        <option value="" selected>انتخاب کنید ...</option>
                                                        @foreach($vehicle_brands as $vehicle_brand)
                                                                <option value="{{ $vehicle_brand->id }}">{{ $vehicle_brand->title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @if ($errors->has('vehicle_brand'))
                                                        <div data-field="vehicle_brand" class="text-danger">{{ $errors->first('vehicle_brand') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="user_id">تیپ وسیله نقلیه</label>
                                                <div class="position-relative">
                                                    <select id="vehicle_type" name="vehicle_type" class="form-select">
                                                        <option value="" selected>انتخاب کنید ...</option>
                                                        @foreach($vehicle_types as $vehicle_type)
                                                            <option value="{{ $vehicle_type->id }}">{{ $vehicle_type->title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @if ($errors->has('vehicle_type'))
                                                        <div data-field="vehicle_type" class="text-danger">{{ $errors->first('vehicle_type') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="capacity">ظرفیت</label>
                                                <input type="number" id="capacity" name="capacity" class="form-control" required>
                                                @if ($errors->has('capacity'))
                                                    <div data-field="capacity" class="text-danger">{{ $errors->first('capacity') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="state">شهر محل برگذاری</label>
                                                <div class="position-relative">
                                                    <select id="city" name="city" class="form-select">
                                                        @foreach($cities as $city)
                                                            <option value="{{ $city->id }}">{{ $city->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="state">وضعیت</label>
                                                <div class="position-relative">
                                                    <select id="state" name="status" class="form-select">
                                                        <option value="1" {{ '1' == old('status') ? 'selected' : '' }}>فعال
                                                        </option>
                                                        <option value="0" {{ '0' == old('status') ? 'selected' : '' }}>غیر
                                                            فعال</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label" for="title">تصویر</label>
                                                <div class="input-group">
                                                    <input type="text" id="image1" class="form-control" name="image"
                                                           aria-label="Image" aria-describedby="button-image">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                    </div>
                                                </div>
                                            </div>




                                            <div class="col-md-4">
                                                <label for="selectpickerSelectDeselect" class="form-label">سرویس های نمایشی</label>
                                                <select id="selectpickerSelectDeselect" name="service_ids[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                    @foreach($services as $service)
                                                        <option value="{{$service->id}}" data-lang="en">{{$service->title}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-2">
                                                <span>*</span>
                                                <label class="form-label" for="status_pay">نوع</label>
                                                <div class="position-relative">
                                                    <select id="status_pay" name="status_pay" class="form-select" onchange="togglePriceField()">
                                                        <option value="free">رایگان</option>
                                                        <option value="membership">حق عضویت</option>
                                                        <option value="none_free">غیر رایگان</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-2" id="price-container" style="display:none;">
                                                <span>*</span>
                                                <label class="form-label" for="price">هزینه</label>
                                                <input type="text" id="price" name="price" class="form-control">
                                                @if ($errors->has('price'))
                                                    <div data-field="price" class="text-danger">{{ $errors->first('price') }}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-12 mt-2">
                                                <label class="form-label" for="desc">متن بزرگ</label>
                                                <textarea  type="text" id="body"  name="bodyy" class="form-control" ><a href="{{config('app.url')}}" target="_blank" dir="rtl" style="color: #0000ff;">{{config('app.text_editor')}}</a></textarea>
                                                @if($errors->has('bodyy'))
                                                    <div data-field="desc" class="text-danger">{{ $errors->first('bodyy') }}</div>
                                                @endif


                                                <br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{ route('admin.competition.index') }}" type="reset"
                               class="btn btn-label-secondary">انصراف</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
            integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>

    <script>
        document.getElementById('membership_fee').addEventListener('input', function(event) {
            let value = event.target.value.replace(/,/g, ''); // Remove existing commas
            if (!isNaN(value) && value !== '') {
                value = Number(value).toLocaleString('en-US');
                event.target.value = value;
            } else {
                event.target.value = '';
            }
        });
    </script>

    <script>
        function togglePriceField() {
            var status = document.getElementById('status_pay').value;
            var priceContainer = document.getElementById('price-container');
            var priceInput = document.getElementById('price');

            if (status === 'none_free') {
                priceContainer.style.display = 'block';
                priceInput.setAttribute('required', 'required'); // افزودن ویژگی required
            } else {
                priceContainer.style.display = 'none';
                priceInput.removeAttribute('required'); // حذف ویژگی required
                priceInput.value = '';  // مقدار اینپوت هزینه را خالی می‌کند
            }
        }
    </script>

    <script>
        function showFields() {
            var vehicleType = document.getElementById('vehicle-type').value;
            var motorField = document.getElementById('motor-field');
            var carFields = document.getElementById('car-fields');
            var motorDetails = document.getElementById('motor_pelak');
            var platePart1 = document.getElementById('plate-part1');
            var platePart2 = document.getElementById('plate-part2');
            var platePart3 = document.getElementById('plate-part3');
            var platePart4 = document.getElementById('plate-part4');

            motorField.style.display = 'none';
            carFields.style.display = 'none';

            if (vehicleType === '1') {
                motorField.style.display = 'block';
                carFields.style.display = 'none';
                platePart1.value = '';
                platePart2.value = '';
                platePart3.value = '';
                platePart4.value = '';
                motorDetails.required = true;
                platePart1.required = false;
                platePart2.required = false;
                platePart3.required = false;
                platePart4.required = false;
            } else if (vehicleType === '0') {
                carFields.style.display = 'block';
                motorField.style.display = 'none';
                motorDetails.value = '';
                motorDetails.required = false;
                platePart1.required = true;
                platePart2.required = true;
                platePart3.required = true;
                platePart4.required = true;
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            showFields();
        });
    </script>

    <script src="{{ asset('modules/core/js/title-to-slug.js') }}"></script>

    <script>

        function addFormElements(current) {
            let newForm =   $(current).parents('.form-list').append($(current).parents('.form-row').clone())
            let eles =   document.getElementsByClassName('new-image');
            var i = 0;
            for (let item of eles){
                item.id = 'image'+ i
                i++
            }
        }

    </script>

    <script>
        function formatNumberInput(input) {
            // حذف کاراکترهای غیر عددی
            let value = input.value.replace(/,/g, '');
            // جدا کردن اعداد هر ۳ رقم
            value = value.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
            input.value = value;
        }

        document.getElementById('price').addEventListener('input', function () {
            formatNumberInput(this);
        });
    </script>
@endsection

