@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.competition.index')}}" method="get"  target="_blank">
                                    <div class="row">
                                            <div class="col-2">
                                                <label for="flatpickr-datetime" class="form-label">تاریخ شروع رویداد</label>
                                                <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="competition_start_date" id="publish_up" />
                                            </div>
                                            <div class="col-2">
                                                <label for="flatpickr-datetime" class="form-label">تاریخ پایان رویداد</label>
                                                <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="competition_end_date" id="publish_down" />
                                            </div>
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">وضعیت</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="state[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                <option value="accepted">تایید شده</option>--}}
{{--                                                <option value="rejected">رد شده</option>--}}
{{--                                                <option value="pending">درحال بررسی</option>--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">مدل</label>--}}
{{--                                            <input type="number" id="model_year"  name="model_year" class="form-control" placeholder="مدل" value="{{ old('model_year') }}">--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($categories as $category)--}}
{{--                                                    <option value="{{ $category->id }}">{{ $category->title }}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">برند</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="brands[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($brands as $brand)--}}
{{--                                                    <option value="{{ $brand->id }}">{{ $brand->title }}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">تیپ</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="types[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($types as $type)--}}
{{--                                                    <option value="{{ $type->id }}">{{ $type->title }}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">کاربر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="users[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($users as $user)--}}
{{--                                                    <option value="{{ $user->id }}">{{ $user->profile->first_name . '-' . $user->mobile }}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($categories as $category)--}}
{{--                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category])--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">نوع خبر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="type_id[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($types as $type)--}}
{{--                                                    <option value="{{$type->id}}">{{$type->title}}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">منابع خبر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="source_id[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($sources as $source)--}}
{{--                                                    <option value="{{$source->id}}">{{$source->title}}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">وضعیت خبر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="state[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                <option value="1">فعال</option>--}}
{{--                                                <option value="0">غیر فعال</option>--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">ویژه</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="special[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                <option value="1">ویژه</option>--}}
{{--                                                <option value="0">غیر ویژه</option>--}}
{{--                                            </select>--}}
{{--                                        </div>--}}
                                        <div class="row" style="margin-top: 20px;">
                                            <div class="col-md-12">
                                                <div class="row" style="justify-content: center;">
                                                    <div class="col-md-1">
                                                        <button name="filter" type="submit" class="btn btn-primary me-1">جستجو</button>
                                                    </div>
{{--                                                    <div class="col-md-1">--}}
{{--                                                        <button name="print" type="submit" class="btn btn-warning me-1">پرینت</button>--}}
{{--                                                    </div>--}}

{{--                                                    <div class="col-md-1">--}}
{{--                                                        <button name="excel" type="submit" class="btn btn-success me-1">اکسل</button>--}}
{{--                                                    </div>--}}

{{--                                                    <div class="col-md-2">--}}
{{--                                                        <button name="pdf" type="submit" class="btn btn-danger me-1">پی دی اف</button>--}}
{{--                                                    </div>--}}
                                                </div>
                                            </div>
{{--                                        </div>--}}
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>

    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.competition') }}" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.competition.create') }}" role="button"
                   aria-expanded="false">جدید</a>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("رویداد ها")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>ظرفیت</th>
                    <th>تاریخ و ساعت شروع</th>
                    <th>تاریخ و ساعت پایان</th>
                    <th>لیست ثبت نام کنندگان</th>
                    <th>نوع</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($competitions as $competition)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $competition->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>


                        <td>
                            @if($competition->status == 0)
                                <a style="color: red" href="{{route('admin.competition.index')}}">
                                    <b class="active">{{ $competition->id }} -
                                        {{ $competition->title }}</b>
                                </a>
                            @else
                                <a style="color: blue" href="{{route('admin.competition.index')}}">
                                    <b class="active">{{ $competition->id }} -
                                        {{ $competition->title }}</b>
                                </a>
                            @endif
                        </td>

                        <td>
                            {{ $competition->capacity }}
                        </td>

                        <td>
                            {{ Verta($competition->start_time)->format('Y-m-d H:i:s') }}
                        </td>

                        <td>
                            {{ Verta($competition->end_time)->format('Y-m-d H:i:s') }}
                        </td>

                        <td>
                            <a href="{{ route('admin.members', $competition->id) }}">نمایش</a>
                        </td>

                        <td>
                            @if($competition->status_pay == "free")
                                رایگان
                            @elseif($competition->status_pay == "none_free")
                                غیر رایگان
                            @elseif($competition->status_pay == "membership")
                                حق عضویت
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.competition.edit', $competition->id) }}"><i
                                            class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $competition->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $competition->id }}"
                                          action="{{ route('admin.competition.destroy', $competition->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

        </div>
    </div>
@endsection
