<?php

namespace Modules\Contact\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Modules\Contact\app\Models\Contact;
use Modules\Contact\app\Models\Cooperation;
use Modules\Core\app\Http\Controllers\Helpers\SmsHelper;
use Modules\Core\app\Http\Controllers\Helpers\Str;

class CooperationController extends Controller
{
    use SmsHelper;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('contact.access');
        $query = Cooperation::
            when(!is_null(Request()->mobile),function ($query){
                 return $query->where('mobile','LIKE','%'.Request()->mobile."%");
             })
            ->when(!is_null(Request()->name),function ($query){
                return $query->where('name','LIKE','%'.Request()->name."%");
            })
            ->when(!is_null(Request()->read),function ($query){
                return $query->whereIn('read',Request()->read);
            })
            ->when(!is_null(Request()->start_date), function ($query) {
                $start_date = Str::convertToGregorian(Request()->start_date . ':00');
                return $query->whereDate('created_at','>=',$start_date);
            })

            ->when(!is_null(Request()->end_date), function ($query)  {
                $end_date = Str::convertToGregorian(Request()->end_date . ':00');
                return $query->whereDate('created_at','<=',$end_date);
            })
            ->latest();


        if(isset($_GET['pdf'])){
            $cooperations = $query->limit(200)->get();
            Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $pdf = Pdf::loadView('contact::print.cooperations', ['cooperations' => $cooperations]);
            return $pdf->download('cooperations.pdf');
        }


        $cooperations = $query->paginate(15);

        return view('contact::Dashboard.Frest.cooperation.index',compact('cooperations'));
    }


    public function update(Request $request, $id)
    {
        $cooperation = Cooperation::find($id);
        $this->authorize('contact.access');


        if($cooperation->read != 1 && $request->read == 1){
            //Confirm
            $this->send($request->mobile,"havashConfirmCustomerOrder",$request->name);
        }


        $cooperation->read = $request->read;

        $cooperation->save();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.cooperation.index');
    }

    public function destroy($id)
    {
        $object = Cooperation::find($id);
        $this->authorize('contact.access');
        $object->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


}

