<?php

namespace Modules\Contact\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Modules\Contact\app\Models\Contact;
use Modules\Core\app\Http\Controllers\Helpers\Str;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('contact.access');
        $query = Contact::where('type','order')
             ->when(!is_null(Request()->mobile),function ($query){
                 return $query->where('mobile','LIKE','%'.Request()->mobile."%");
             })
            ->when(!is_null(Request()->name),function ($query){
                return $query->where('name','LIKE','%'.Request()->name."%");
            })
            ->when(!is_null(Request()->read),function ($query){
                return $query->whereIn('read',Request()->read);
            })
            ->when(!is_null(Request()->start_date), function ($query) {
                $start_date = Str::convertToGregorian(Request()->start_date . ':00');
                return $query->whereDate('created_at','>=',$start_date);
            })

            ->when(!is_null(Request()->end_date), function ($query)  {
                $end_date = Str::convertToGregorian(Request()->end_date . ':00');
                return $query->whereDate('created_at','<=',$end_date);
            })
            ->latest();


        if(isset($_GET['pdf'])){
            $orders = $query->limit(200)->get();
            Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $pdf = Pdf::loadView('contact::print.orders', ['orders' => $orders]);
            return $pdf->download('orders.pdf');
        }


        $orders = $query->paginate(15);

        return view('contact::Dashboard.Frest.order.index',compact('orders'));
    }


    public function update(Request $request, $id)
    {
        $order = Contact::find($id);
        $this->authorize('contact.access');


        if($order->read != 1 && $request->read == 1){
            //Confirm
        }

        if($order->read != 2 && $request->read == 2){
            //Reject
        }

        if($order->read != 3 && $request->read == 3){
            //Hold
        }

        $order->read = $request->read;

        $order->save();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.order.index');
    }


}

