<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Area\app\Models\City;
use Modules\Category\app\Models\Category;
use Modules\Product\app\Models\Product;

class Contact extends Model
{
    use SoftDeletes;

    protected $fillable = ['name','email','subject_id','city_id','counsultant_id',
'mobile','address','ip','user-agent','question','product_id','answer','read','type'];

    public function subject(){
        return $this->belongsTo(Category::class,'subject_id');
    }


    public function product(){
        return $this->belongsTo(Product::class,'product_id');
    }

    public function city(){
        return $this->belongsTo(City::class,'city_id');
    }

}
