@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    درخواست همکاری
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/modal-add-new-cc.js') }}"></script>
    <script src="{{ asset('template/admin/frest/js/modal-add-new-address.js') }}"></script>
    <script src="{{ asset('template/admin/frest/js/modal-edit-user.js') }}"></script>
    <script src="{{ asset('template/admin/frest/js/modal-enable-otp.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.cooperation.index')}}"
                                    method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <label for="selectpickerSelectDeselect" class="form-label">نام و نام خانوادگی</label>
                                            <input type="text" id="name"  name="name" class="form-control" placeholder="نام و نام خانوادگی" value="{{old('name')}}">
                                        </div>

                                        <div class="col-md-2">
                                            <label for="selectpickerSelectDeselect" class="form-label">موبایل</label>
                                            <input type="text" id="mobile"  name="mobile" class="form-control" placeholder="موبایل" value="{{old('mobile')}}">
                                        </div>


                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">وضعیت</label>
                                            <select id="selectpickerSelectDeselect" name="read[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                <option value="0">بررسی نشده</option>
                                                <option value="1">تایید شده</option>
                                                <option value="2">رد شده</option>
                                                <option value="3">نگه داشته شده</option>
                                            </select>
                                        </div>


                                        <div class="col-2">
                                            <label for="flatpickr-datetime" class="form-label">از تاریخ</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="start_date" id="publish_up" />
                                        </div>

                                        <div class="col-2">
                                            <label for="flatpickr-datetime" class="form-label">تا تاریخ</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="end_date" id="publish_down" />
                                        </div>



                                        <div class="row" style="margin-top: 20px;">
                                            <div class="col-md-12">
                                                <div class="row" style="justify-content: center;">
                                                    <div class="col-md-1">
                                                        <button name="filter" type="submit" class="btn btn-primary me-1">جستجو</button>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <button name="print" type="submit" class="btn btn-warning me-1">پرینت</button>
                                                    </div>

                                                    <div class="col-md-1">
                                                        <button name="excel" type="submit" class="btn btn-success me-1">اکسل</button>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <button name="pdf" type="submit" class="btn btn-danger me-1">پی دی اف</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
{{--        <form action="{{ route('admin.bulk.cooperations') }}" method="get">--}}
{{--            <p class="demo-inline-spacing">--}}
{{--                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>--}}
{{--                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>--}}
{{--                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>--}}
{{--            </p>--}}
{{--            <input type="text" id="items" name="items" value="" style="display: none;">--}}
{{--        </form>--}}

            <h5 class="card-header">درخواست همکاری</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>کاربر</th>
                            <th>شهر</th>

                            <th>متراژ</th>
                            <th>وضعیت همکاری</th>
                            <th>تاریخ ایجاد همکاری</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($cooperations as $cooperation)
                            <tr >

                                <!-- Modal -->

                                <th>
                                    <div class="modal fade" id="update-order-{{$cooperation->id}}" data-bs-backdrop="static" tabindex="-1">
                                        <div class="modal-dialog">
                                            <form class="modal-content" action="{{route('admin.cooperation.update',$cooperation->id)}}" method="post">
                                                @csrf
                                                @method('PATCH')
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="backDropModalTitle">بررسی درخواست</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">

                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('name') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">نام</label>
                                                                <input type="text" name="name" required class="form-control" id="field-1" placeholder="نام" value="{{old('name',$cooperation->name)}}">
                                                                @if($errors->has('name'))
                                                                    <span class="help-doc text-danger">
                                                                         <strong>{{ $errors->first('name') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('mobile') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">نام</label>
                                                                <input type="text" name="mobile" required class="form-control" id="field-1" placeholder="نام" value="{{old('mobile',$cooperation->mobile)}}">
                                                                @if($errors->has('mobile'))
                                                                    <span class="help-doc text-danger">
                                                                         <strong>{{ $errors->first('mobile') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('city') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">شهر</label>
                                                                <input type="text" name="city" required class="form-control" id="field-1" placeholder="شهر" value="{{old('city',$cooperation->city)}}">
                                                                @if($errors->has('city'))
                                                                    <span class="help-doc text-danger">
                                                                         <strong>{{ $errors->first('city') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('state') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">استان</label>
                                                                <input type="text" name="state" required class="form-control" id="field-1" placeholder="شهر" value="{{old('state',$cooperation->state)}}">
                                                                @if($errors->has('state'))
                                                                    <span class="help-doc text-danger">
                                                                         <strong>{{ $errors->first('state') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('postal_code') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">کد پستی</label>
                                                                <input type="text" name="postal_code" required class="form-control" id="field-1" placeholder="شهر" value="{{old('postal_code',$cooperation->postal_code)}}">
                                                                @if($errors->has('postal_code'))
                                                                    <span class="help-doc text-danger">
                                                                         <strong>{{ $errors->first('postal_code') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('address') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">آدرس</label>
                                                                <input type="text" name="address" required class="form-control" id="field-1" placeholder="شهر" value="{{old('address',$cooperation->address)}}">
                                                                @if($errors->has('address'))
                                                                    <span class="help-doc text-danger">
                                                                         <strong>{{ $errors->first('address') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group {{ $errors->has('body') ? 'has-errors' : '' }}">
                                                                <label for="field-2" class="control-label">درخواست</label>
                                                                <textarea  name="body" class="form-control" id="field-2"  >{{old('body',$cooperation->body)}}</textarea>
                                                                @if($errors->has('body'))
                                                                    <span class="help-doc text-danger">
                                                                        <strong>{{ $errors->first('body') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 {{ $errors->has('read') ? 'has-errors' : '' }}">
                                                            <label for="field-2" class="control-label">وضعیت</label>
                                                            <select  name="read" required class="form-control" id="field-2"  >
                                                                <option value="1" {{$cooperation->read == 0 ? 'selected' : ''}}>بررسی نشده</option>
                                                                <option value="1" {{$cooperation->read == 1 ? 'selected' : ''}}>تایید شده</option>
                                                                <option value="2" {{$cooperation->read == 2 ? 'selected' : ''}}>رد شده</option>
                                                                <option value="3" {{$cooperation->read == 3 ? 'selected' : ''}}>نگه داشته شده</option>
                                                            </select>
                                                            @if($errors->has('read'))
                                                                <span class="help-doc text-danger">
                                                                 <strong>{{ $errors->first('read') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>


                                                    </div>

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                                                    <button type="submit" class="btn btn-primary">بروزرسانی</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$cooperation->id}}" type="checkbox">
                                        <label for="bulk-ids">{{$cooperation->id}}</label>
                                    </div>
                                </th>
                                <td> {{$cooperation->name }} - {{$cooperation->mobile }} </td>
                                <td> {{$cooperation->city_id != null ? $cooperation->city->title : 'ثبت نشد' }} </td>
                                <td> {{$cooperation->meter }} </td>
                                <td>
                                @if($cooperation->read == 0)
                                    <span class="badge bg-label-danger me-1">بررسی نشده</span>
                                @endif
                                @if($cooperation->read == 1)
                                    <span class="badge bg-label-success me-1">تایید شده</span>
                                @endif
                                @if($cooperation->read == 2)
                                    <span class="badge bg-label-danger me-1">رد شده</span>
                                @endif
                                @if($cooperation->read == 3)
                                    <span class="badge bg-label-danger me-1">نگه داشته شده</span>
                                @endif
                                </td>
                                <td> {{Verta($cooperation->created_at)->format('Y-m-d H:i')}}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#update-order-{{$cooperation->id}}"><i class="bx bx-edit-alt me-1"></i>بررسی</a>

                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$cooperation->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$cooperation->id}}" action="{{ route('admin.cooperation.destroy', $cooperation->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>


                            </tr>

                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $cooperations->render() }}
                </div>
            </div>





    </div>
@endsection
