@extends('contact::print.master')

 @section('content')

    <div class="table-responsive">
        <table class="table table-hover mails m-0 table table-actions-bar">

            <thead>
            <tr>
                <th>کاربر</th>
                <th>محصول</th>
                <th>وضعیت سفارش</th>
                <th>تاریخ ایجاد سفارش</th>
            </tr>
            </thead>

            <tbody>
            @foreach($orders as $key => $order)
                <tr>
                    <td> {{$order->name }} - {{$order->mobile }} </td>
                    <td> {{$order->params }} </td>
                    <td>
                        @if($order->read == 0)
                            <span class="badge bg-label-danger me-1">بررسی نشده</span>
                        @endif
                        @if($order->read == 1)
                            <span class="badge bg-label-success me-1">تایید شده</span>
                        @endif
                        @if($order->read == 2)
                            <span class="badge bg-label-danger me-1">رد شده</span>
                        @endif
                        @if($order->read == 3)
                            <span class="badge bg-label-danger me-1">نگه داشته شده</span>
                        @endif
                    </td>
                    <td> {{Verta($order->created_at)->format('Y-m-d H:i')}}</td>
                </tr>

            @endforeach

            </tbody>

        </table>
    </div>

 @endsection
