<?php

namespace Modules\Core\app\Http\Controllers\Helpers\HelperFetchData;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Modules\Category\app\Models\Category;
use Modules\Core\App\Http\Controllers\Helpers\Str;
use Modules\News\app\Models\News;

trait NewsHelper
{


    public static function news($id = null){

        $category = null;

        if($id != null){
            $category = Category::whereState(1)->whereId($id)->first();

            SEOMeta::setTitle($category->title);
            SEOMeta::setDescription($category->meta_desc);
            SEOMeta::addMeta('article:section', $category->title, 'property');

            SEOMeta::setCanonical(config('app.url').$category->route);
            OpenGraph::setDescription($category->meta_desc);
            OpenGraph::setTitle($category->title);
            OpenGraph::setUrl(config('app.url').$category->route);
            OpenGraph::addProperty('type', 'website');
            OpenGraph::addProperty('locale','fa_IR');
            OpenGraph::addProperty('locale:alternate', ['fa_IR']);
            OpenGraph::addImage($category->image);
            OpenGraph::addImage($category->image);
            OpenGraph::addImage(['url' => $category->image, 'size' => 300]);
            OpenGraph::addImage( $category->image, ['height' => 300, 'width' => 300]);
            JsonLd::setTitle($category->title);
            JsonLd::setDescription($category->meta_desc);
            JsonLd::setType('Article');
            JsonLd::addImage($category->image);
        }



        $special = [];

        $result = News::
        when($id != null && $category->key != 'all',function ($query) use ($id){
            $query->whereHas('category',function ($query2) use ($id){
                $query2->whereState(1)->where('id',$id);
            })
                ->orWhereHas('categories',function ($query3) use ($id){
                    $query3->whereState(1)->whereIn('id',[$id]);
                });
        })
            ->when(Request()->service != null, function ($query){
                return $query->whereHas('services',function ($query) {
                    return $query->where('service_id',Request()->service);
                });
            })
            ->when(Request()->tags != null, function ($query){
                return $query->whereHas('tags',function ($query){
                    return $query->where('name',Request()->tags);
                });
            })
            ->when(!is_null(Request()->start_date), function ($query) {
                $start_date = Str::convertToGregorian(str_replace('/','-',Request()->start_date) . ' 00:00:00');
                return $query->whereDate('created_at','>=',$start_date);
            })
            ->when(!is_null(Request()->end_date), function ($query)  {
                $end_date = Str::convertToGregorian(str_replace('/','-',Request()->end_date) . ' 00:00:00');
                return $query->whereDate('created_at','<=',$end_date);
            })
            ->when(isset(Request()->q),function ($query){
                $query ->where('title','LIKE','%'.Request()->q."%")
                    ->orWhere('body','LIKE','%'.Request()->q."%")
                    ->orWhere('lead','LIKE','%'.Request()->q."%");
            })
            ->latest();


            $special = [];
            if(Request()->page == null){
                $query = clone  $result;
                $special = $query->where('special',1)->limit(4)->get();
            }

            $news = $result->paginate(15);


        return ['news' => $news,'category' => $category,'special' => $special];

    }

    public static function showNews($id){

        $news = News::active()->whereId($id)->first();


        SEOMeta::setTitle($news->title);
        SEOMeta::setDescription($news->lead);
        SEOMeta::addMeta('article:published_time', $news->publish_up, 'property');
        SEOMeta::addMeta('article:section', $news->category->title, 'property');

        SEOMeta::setCanonical(config('app.url').$news->route);
        OpenGraph::setDescription($news->meta_desc);
        OpenGraph::setTitle($news->title);
        OpenGraph::setUrl(config('app.url').$news->route);
        OpenGraph::addProperty('type', 'article');
        OpenGraph::addProperty('locale','fa_IR');
        OpenGraph::addProperty('locale:alternate', ['fa_IR']);
        OpenGraph::addImage($news->image1);
        OpenGraph::addImage($news->image1);
        OpenGraph::addImage(['url' => $news->image1, 'size' => 300]);
        OpenGraph::addImage( $news->image1, ['height' => 300, 'width' => 300]);
        JsonLd::setTitle($news->title);
        JsonLd::setDescription($news->meta_desc);
        JsonLd::setType('Article');
        JsonLd::addImage($news->image1);

        $news_related = News::active()
            ->where('id','<>',$id)
            ->where('cat_id',$news->cat_id)->latest()->take(8)->get();



        $news->increment('view_count');
        $shareComponent = \Share::page(
            config('app.APP_URL').$news->route,
            $news->title
        )->facebook()
            ->twitter()
            ->linkedin()
            ->telegram()
            ->whatsapp()
            ->reddit()->getRawLinks();

 return ['news' => $news,'news_related' => $news_related,'shareComponent' => $shareComponent];


    }



}
