<?php

namespace Modules\Core\app\Http\Controllers\Helpers\HelperFetchData;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Modules\Category\app\Models\Category;
use Modules\Product\app\Models\Color;
use Modules\Product\app\Models\Material;
use Modules\Product\app\Models\Product;

trait ProductHelper
{




    public static function showProduct($id){

        $product = Product::active()->whereId($id)->first();


        SEOMeta::setTitle($product->title);
        SEOMeta::setDescription($product->lead);
        SEOMeta::addMeta('article:published_time', $product->publish_up, 'property');
        SEOMeta::addMeta('article:section', $product->category->title, 'property');

        SEOMeta::setCanonical(config('app.url').$product->route);
        OpenGraph::setDescription($product->meta_desc);
        OpenGraph::setTitle($product->title);
        OpenGraph::setUrl(config('app.url').$product->route);
        OpenGraph::addProperty('type', 'article');
        OpenGraph::addProperty('locale','fa_IR');
        OpenGraph::addProperty('locale:alternate', ['fa_IR']);
        OpenGraph::addImage($product->image);
        OpenGraph::addImage($product->image);
        OpenGraph::addImage(['url' => $product->image, 'size' => 300]);
        OpenGraph::addImage( $product->image, ['height' => 300, 'width' => 300]);
        JsonLd::setTitle($product->title);
        JsonLd::setDescription($product->meta_desc);
        JsonLd::setType('Article');
        JsonLd::addImage($product->image);

        $product_related = Product::active()
            ->where('id','<>',$id)
            ->where('main_cat',$product->main_cat)->latest()->take(8)->get();



        $product->increment('view_count');
        $shareComponent = \Share::page(
            config('app.APP_URL').$product->route,
            $product->title
        )->facebook()
            ->twitter()
            ->linkedin()
            ->telegram()
            ->whatsapp()
            ->reddit()->getRawLinks();

            return [
                'shareComponent' => $shareComponent,
                'product_related' => $product_related,
                'product' => $product,
            ];


    }

    public static function products($id=null){

        $category = null;

        if($id != null){
            $category = Category::whereState(1)->whereId($id)->first();

            SEOMeta::setTitle($category->title);
            SEOMeta::setDescription($category->meta_desc);
            SEOMeta::addMeta('article:section', $category->title, 'property');

            SEOMeta::setCanonical(config('app.url').$category->route);
            OpenGraph::setDescription($category->meta_desc);
            OpenGraph::setTitle($category->title);
            OpenGraph::setUrl(config('app.url').$category->route);
            OpenGraph::addProperty('type', 'website');
            OpenGraph::addProperty('locale','fa_IR');
            OpenGraph::addProperty('locale:alternate', ['fa_IR']);
            OpenGraph::addImage($category->image);
            OpenGraph::addImage($category->image);
            OpenGraph::addImage(['url' => $category->image, 'size' => 300]);
            OpenGraph::addImage( $category->image, ['height' => 300, 'width' => 300]);
            JsonLd::setTitle($category->title);
            JsonLd::setDescription($category->meta_desc);
            JsonLd::setType('Article');
            JsonLd::addImage($category->image);
        }

        $categories = Category::whereNull('parent_id')->where('state',1)->where('type','products')->latest()->get();
        $colors = Color::latest()->get();
        $materials = Material::latest()->get();

        $products = Product::
        when($id != null && $category->key != 'all',function ($query) use ($id,$category){
            $query->whereHas('category',function ($query2) use ($id){
                $query2->whereState(1)->where('id',$id);
            })
                ->orWhereHas('categories',function ($query3) use ($id){
                    $query3->whereState(1)->whereIn('id',[$id]);
                })
                ->orWhereHas('category',function ($query3) use ($category){
                    $query3->whereState(1)->whereIn('id',$category->childrenCategory());
                });
        })
            ->when(Request()->material_body != null,function ($query){
                $query->whereHas('materials',function ($query2){
                    $query2->where('material_id' ,Request()->material_body);
                });
            })
            ->when(Request()->material_wood != null,function ($query){
                $query->whereHas('materials',function ($query2){
                    $query2->where('material_id' ,Request()->material_wood);
                });
            })
            ->when(Request()->color_wood != null,function ($query){
                $query->whereHas('colors',function ($query2){
                    $query2->where('color_id' ,Request()->color_wood);
                });
            })
            ->when(Request()->color_body != null,function ($query){
                $query->whereHas('colors',function ($query2){
                    $query2->where('color_id' ,Request()->color_body);
                });
            })
            ->when(isset(Request()->q),function ($query){
                $query ->where('title','LIKE','%'.Request()->q."%")
                    ->orWhere('body','LIKE','%'.Request()->q."%");
            })
            ->latest()->paginate(15);

        return ['products' => $products,'category' => $category,'colors' => $colors,
            'materials' => $materials,'categories'=>$categories];

    }
}
