<?php


namespace Modules\Core\app\Http\Controllers\Helpers;



use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;


class Log
{
    /**
     * Add to log.
     *
     * @param Model $model
     * @param User|Authenticatable $user
     * @param string $message
     * @param array $properties
     *
     * @return void
     */
    public static function add(Model $model, $user, string $message, array $properties = [])
    {
        $properties['ip'] = request()->getClientIp();

        activity()
            ->performedOn($model)
            ->causedBy($user)
            ->withProperties($properties)
            ->log($message);
    }
}
