<?php

namespace Modules\Core\app\Http\Controllers\Helpers;

use Hekmatinasser\Verta\Verta;

class Str
{
    /**
     * Generate persian slug.
     *
     * @param string $string
     * @param string $separator
     * @return mixed|null|string|string[]
     */
    public static function slug($string, $separator = '-')
    {
        $_transliteration = array(
            '/ä|æ|ǽ/' => 'ae',
            '/ö|œ/' => 'oe',
            '/ü/' => 'ue',
            '/Ä/' => 'Ae',
            '/Ü/' => 'Ue',
            '/Ö/' => 'Oe',
            '/À|Á|Â|Ã|Å|Ǻ|Ā|Ă|Ą|Ǎ/' => 'A',
            '/à|á|â|ã|å|ǻ|ā|ă|ą|ǎ|ª/' => 'a',
            '/Ç|Ć|Ĉ|Ċ|Č/' => 'C',
            '/ç|ć|ĉ|ċ|č/' => 'c',
            '/Ð|Ď|Đ/' => 'D',
            '/ð|ď|đ/' => 'd',
            '/È|É|Ê|Ë|Ē|Ĕ|Ė|Ę|Ě/' => 'E',
            '/è|é|ê|ë|ē|ĕ|ė|ę|ě/' => 'e',
            '/Ĝ|Ğ|Ġ|Ģ/' => 'G',
            '/ĝ|ğ|ġ|ģ/' => 'g',
            '/Ĥ|Ħ/' => 'H',
            '/ĥ|ħ/' => 'h',
            '/Ì|Í|Î|Ï|Ĩ|Ī|Ĭ|Ǐ|Į|İ/' => 'I',
            '/ì|í|î|ï|ĩ|ī|ĭ|ǐ|į|ı/' => 'i',
            '/Ĵ/' => 'J',
            '/ĵ/' => 'j',
            '/Ķ/' => 'K',
            '/ķ/' => 'k',
            '/Ĺ|Ļ|Ľ|Ŀ|Ł/' => 'L',
            '/ĺ|ļ|ľ|ŀ|ł/' => 'l',
            '/Ñ|Ń|Ņ|Ň/' => 'N',
            '/ñ|ń|ņ|ň|ŉ/' => 'n',
            '/Ò|Ó|Ô|Õ|Ō|Ŏ|Ǒ|Ő|Ơ|Ø|Ǿ/' => 'O',
            '/ò|ó|ô|õ|ō|ŏ|ǒ|ő|ơ|ø|ǿ|º/' => 'o',
            '/Ŕ|Ŗ|Ř/' => 'R',
            '/ŕ|ŗ|ř/' => 'r',
            '/Ś|Ŝ|Ş|Ș|Š/' => 'S',
            '/ś|ŝ|ş|ș|š|ſ/' => 's',
            '/Ţ|Ț|Ť|Ŧ/' => 'T',
            '/ţ|ț|ť|ŧ/' => 't',
            '/Ù|Ú|Û|Ũ|Ū|Ŭ|Ů|Ű|Ų|Ư|Ǔ|Ǖ|Ǘ|Ǚ|Ǜ/' => 'U',
            '/ù|ú|û|ũ|ū|ŭ|ů|ű|ų|ư|ǔ|ǖ|ǘ|ǚ|ǜ/' => 'u',
            '/Ý|Ÿ|Ŷ/' => 'Y',
            '/ý|ÿ|ŷ/' => 'y',
            '/Ŵ/' => 'W',
            '/ŵ/' => 'w',
            '/Ź|Ż|Ž/' => 'Z',
            '/ź|ż|ž/' => 'z',
            '/Æ|Ǽ/' => 'AE',
            '/ß/' => 'ss',
            '/Ĳ/' => 'IJ',
            '/ĳ/' => 'ij',
            '/Œ/' => 'OE',
            '/ƒ/' => 'f'
        );
        $quotedReplacement = preg_quote($separator, '/');
        $merge = array(
            '/[^\s\p{Zs}\p{Ll}\p{Lm}\p{Lo}\p{Lt}\p{Lu}\p{Nd}]/mu' => ' ',
            '/[\s\p{Zs}]+/mu' => $separator,
            sprintf('/^[%s]+|[%s]+$/', $quotedReplacement, $quotedReplacement) => '',
        );
        $map = $_transliteration + $merge;
        unset($_transliteration);
        return mb_strtolower(preg_replace(array_keys($map), array_values($map), $string));
    }

    /**
     * Implode array to string.
     *
     * @param array $value
     * @param string $glue
     * @return string
     */
    public static function implode(array $value, string $glue)
    {
        return implode($glue, $value);
    }

    /**
     * Convert farsi to english numbers.
     *
     * @param string $numbers
     * @return int
     */
    public static function faToEnNumbers(string $numbers)
    {
        $persianDigits1 = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $persianDigits2 = ['٩', '٨', '٧', '٦', '٥', '٤', '٣', '٢', '١', '٠'];
        $allPersianDigits = array_merge($persianDigits1, $persianDigits2);
        $replaces = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '9', '8', '7', '6', '5', '4', '3', '2', '1', '0'];

        return (int) str_replace($allPersianDigits, $replaces, $numbers);
    }

    /**
     * Remove comma's from value.
     *
     * @param string $value
     *
     * @return string
     */
    public function removeComma(string $value)
    {
        return str_replace(',', '', $value);
    }

    /**
     * Convert jalali date to gregorian date.
     *
     * @param string $jDate
     *
     * @return null|string
     */
    public static function toGregorian(string $jDate)
    {
        $output = null;
        $pattern = '#^(\\d{4})/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])$#';

        if (preg_match($pattern, $jDate)) {
            $jDateArray = explode('/', $jDate);
            $dateArray = Verta::getGregorian(
                $jDateArray[0],
                $jDateArray[1],
                $jDateArray[2]
            );
            $output = implode('/', $dateArray);
        }

        return $output;
    }
    /**
     * Converts a long string of bytes into a readable format e.g KB, MB, GB, TB, YB
     *
     * @param int {Int} num The number of bytes.
     * @return string
     */
    public function readableBytes($bytes)
    {
        $i = floor(log($bytes) / log(1024));
        $sizes = array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');

        return sprintf('%.02F', $bytes / pow(1024, $i)) * 1 . ' ' . $sizes[$i];
    }


    public static function convertToGregorian ($jalali){


        if($jalali != null)
        {
            $date = explode(" ", $jalali)[0];
            $time = explode(" ", $jalali)[1];

            $date = explode("-", $date);
            $date = self::jalali_to_gregorian($date[0],$date[1],$date[2],'-');

            return $date . ' ' . $time;
        }

    }

    public static  function convertToJalali ($gregorian){


        if($gregorian != null)
        {
            $date = explode(" ", $gregorian)[0];
            $time = explode(" ", $gregorian)[1];
            $date = explode("-", $date);
            $date = self::gregorian_to_jalali($date[0],$date[1],$date[2],'-');

            return $date . ' ' . $time;
        }

    }



    public static function implodeArray($array){
        $string = implode(',',$array);

        $str = str_replace(",",'","',$string);

        return '"'.$str.'"';
    }
    public static function jalali_to_gregorian($jy,$jm,$jd,$mod=''){
        if($jy>979){
            $gy=1600;
            $jy-=979;
        }else{
            $gy=621;
        }
        $days=(365*$jy) +(((int)($jy/33))*8) +((int)((($jy%33)+3)/4)) +78 +$jd +(($jm<7)?($jm-1)*31:(($jm-7)*30)+186);
        $gy+=400*((int)($days/146097));
        $days%=146097;
        if($days > 36524){
            $gy+=100*((int)(--$days/36524));
            $days%=36524;
            if($days >= 365)$days++;
        }
        $gy+=4*((int)($days/1461));
        $days%=1461;
        if($days > 365){
            $gy+=(int)(($days-1)/365);
            $days=($days-1)%365;
        }
        $gd=$days+1;
        foreach(array(0,31,(($gy%4==0 and $gy%100!=0) or ($gy%400==0))?29:28 ,31,30,31,30,31,31,30,31,30,31) as $gm=>$v){
            if($gd<=$v)break;
            $gd-=$v;
        }
        return($mod=='')?array($gy,$gm,$gd):$gy.$mod.$gm.$mod.$gd;
    }


    public static  function gregorian_to_jalali($gy,$gm,$gd,$mod=''){
        $g_d_m=array(0,31,59,90,120,151,181,212,243,273,304,334);
        if($gy>1600){
            $jy=979;
            $gy-=1600;
        }else{
            $jy=0;
            $gy-=621;
        }
        $gy2=($gm>2)?($gy+1):$gy;
        $days=(365*$gy) +((int)(($gy2+3)/4)) -((int)(($gy2+99)/100)) +((int)(($gy2+399)/400)) -80 +$gd +$g_d_m[$gm-1];
        $jy+=33*((int)($days/12053));
        $days%=12053;
        $jy+=4*((int)($days/1461));
        $days%=1461;
        if($days > 365){
            $jy+=(int)(($days-1)/365);
            $days=($days-1)%365;
        }
        $jm=($days < 186)?1+(int)($days/31):7+(int)(($days-186)/30);
        $jd=1+(($days < 186)?($days%31):(($days-186)%30));
        return($mod=='')?array($jy,$jm,$jd):$jy.$mod.$jm.$mod.$jd;
    }


    public static  function copyCharacter($num = 0, $char = '-'){
        $result = '';
        for ($i=0;$i < $num;$i++){
             $result .= $char;
        }

        return $result;
    }

    public static function isValidTimeStamp($timestamp,$default = null)
    {
        if($timestamp != null && $timestamp != '0000-00-00 00:00:00') {
            $rules = ['timestamp' => 'date_format:Y-m-d H:i:s'];
            $data = [
                'timestamp' => $timestamp
            ];

            $validator = \Validator::make($data, $rules);



           return $validator->fails() == false ? true : false;

        }

        return false ;

    }

    public static function getTitleBoard($title){
        return Request()->tran_id == null ? $title : "ترجمه های - ".$title;
    }

    public static function getTranslateText($key,$lang){
        $trans = [

            'fa' => [
                'Profile' => 'ناحیه کاربری',
                'Submit' => 'ارسال',
                'More' => 'بیشتر',
                'Return' => 'برگشت',
                'Articles' => 'مقالات',
                'Courses' => 'دوره ها',
                'Products' => 'محصولات',
                'Honors' => 'افتخارات',
                'Businesses' => 'معرفی کسب و کارها',
                'Contact' => 'تماس با ما',
                'Sharing Content' => 'اشتراک مطالب',
                'Email' => 'پست الکترونیکی',
                'Send' => 'ارسال',
                'Mobile' => 'موبایل',
                'Your Information' => 'اطلاعات شما',
                'step 1 : Enter your Information' => 'مرحله اول : اطلاعات خود را وارد کنید !',
                'Name' => 'نام خود را وارد کنید',
                'Categories' => 'حوزه مشاوره خود را انتخاب کنید ',
                'Type' => 'نوع مشاوره خود را انتخاب کنید',
                'Next' => 'مرحله بعد',
                'Choose Your Meeting Method' => 'راه ارتباطی برای مشاوره خود رو انتخاب کنید',
                'Ways' => 'راه های ارتباطی',
                'Welcome' => 'خوش آمدید',
                'The Official Website Of Engineer Amin Cheraghi Far' => 'وب سایت شخصی مهندس امین چراغی فر',
                'Enter Mobile' => 'موبایل خود را وارد کنید',
                'Authentication' => 'احراز هویت',
                'Enter The Code Sent To' => 'کد ارسال شده به موبایل - ',
                'Description' => 'توضیحات',
                'Captcha' => 'کد احراز',
                'Your Request Has Been Successfully Registered' => 'درخواست شما با موفقیت ثبت شد',
                'Sub_total' => 'مبلغ صورتحساب',
                'Discount' => 'تخفیف',
                'Invoice' => 'صورتحساب',
                'Total' => 'مبلغ پرداختی',
                'Payment' => 'پرداخت',
                'Information Invoice' => 'اطلاعات صورتحساب',
                'Success' => 'موفقیت آمیز',
                'Error' => 'خطایی رخ داده',
                'Episodes' => 'قسمت ها',
                'Comments' => 'نظرات',

                'Your invoice has been issued. Please check the information carefully and click on payment' => 'فاکتور شما صادر شد لطفا اطلاعات را به دقت بررسی کنید و روی پرداخت کلیک کنید',
                'Your payment has been successfully completed with tracking code :' => 'درخواست شما با موفقیت انجام شد و کد رهگیری :',
                'Your payment has encountered an error - Code :' => 'درخواست شما با خطا مواجه شد کد خطا : ',
                'To continue payment and connect to the bank portal, click on the link below' => 'بابت ادامه پرداخت و اتصال به درگاه بانکی روی لینک زیر کلیک کنید',

            ],




        ];

        return isset($trans[$lang][$key]) ? $trans[$lang][$key] : $key;

    }


    public static function isHTML($string){
        return ($string != strip_tags($string));
    }
}
