<!DOCTYPE html>
<html lang="fa" class="light-style" dir="rtl" data-theme="theme-default" data-template="horizontal-menu-template">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">

    <title>@yield('title') | {{config('app.name')}}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{asset('modules/core/img/favicon/favicon.ico')}}">

    <!-- Icons -->
    <link rel="stylesheet" href="{{asset('modules/core/vendor/fonts/boxicons.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/fonts/fontawesome.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/fonts/flag-icons.css')}}">

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{asset('modules/core/vendor/css/rtl/core-dark.css')}}" >
    <link rel="stylesheet" href="{{asset('modules/core/vendor/css/rtl/theme-default-dark.css')}}"  >
    <link rel="stylesheet" href="{{asset('modules/core/css/demo.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/css/rtl/rtl.css')}}">

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/typeahead-js/typeahead.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/apex-charts/apex-charts.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/select2/select2.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/bootstrap-select/bootstrap-select.css')}}">
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/flatpickr/flatpickr.css')}}">
    <!-- Page CSS -->

    <!-- Helpers -->

    <script src="{{asset('modules/core/vendor/libs/apex-charts/apexcharts.js')}}"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="{{asset('modules/core/vendor/js/helpers.js')}}"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
{{--    <script src="{{asset('modules/core/vendor/js/template-customizer.js')}}"></script>--}}
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="{{asset('modules/core/js/config.js')}}"></script>
    <link rel="stylesheet" href="{{ asset('vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{asset('modules/core/css/custom.css')}}">

    @yield('style')
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-navbar-full layout-horizontal layout-without-menu">
    <div class="layout-container">



        @include('core::Dashboard.Frest.Layouts._navbar')

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Content wrapper -->
            <div class="content-wrapper">



                <!-- Menu -->
                     @include('core::Dashboard.Frest.Layouts._menu')
                <!-- / Menu -->

                <!-- Content -->

                <div class="container-xxl flex-grow-1 container-p-y">
                    <div class="row">
                        @include('core::Dashboard.Frest.Layouts._errors')
                        @yield('content')
                    </div>
                </div>




                <!--/ Content -->

                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                        <div class="mb-2 mb-md-0">
                            طراحی شده با ❤️ ارائه شده در شرکت
                            <a href="http://borhangfx.com/" target="_blank" class="footer-link fw-semibold">برهان</a>
                        </div>
                        <div>
                            <a href="http://borhangfx.com/" target="_blank" class="footer-link d-none d-sm-inline-block">پشتیبانی</a>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
            <!--/ Content wrapper -->
        </div>

        <!--/ Layout container -->
    </div>
</div>

<!-- Overlay -->
<div class="layout-overlay layout-menu-toggle"></div>

<!-- Drag Target Area To SlideIn Menu On Small Screens -->
<div class="drag-target"></div>

<!--/ Layout wrapper -->

<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="{{asset('modules/core/vendor/libs/jquery/jquery.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/popper/popper.js')}}"></script>
<script src="{{asset('modules/core/vendor/js/bootstrap.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')}}"></script>

<script src="{{asset('modules/core/vendor/libs/hammer/hammer.js')}}"></script>

{{--<script src="{{asset('modules/core/vendor/libs/i18n/i18n.js')}}"></script>--}}
<script src="{{asset('modules/core/vendor/libs/typeahead-js/typeahead.js')}}"></script>

<script src="{{asset('modules/core/vendor/js/menu.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/select2/select2.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/bootstrap-select/bootstrap-select.js')}}"></script>

<script src="{{asset('modules/core/vendor/libs/bootstrap-select/i18n/defaults-fa_IR.js')}}"></script>


<script src="{{asset('modules/core/vendor/libs/moment/moment.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/jdate/jdate.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/flatpickr/flatpickr.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/flatpickr/flatpickr-jdate.js')}}"></script>
<script src="{{asset('modules/core/vendor/libs/flatpickr/l10n/fa-jdate.js')}}"></script>

<!-- Vendors JS -->

<!-- Main JS -->
<script src="{{asset('modules/core/js/main.js')}}"></script>

<script src="{{asset('modules/core/js/form-basic-inputs.js')}}"></script>
<script src="{{asset('modules/core/js/custom.js')}}"></script>



<!-- Page JS -->
@yield('script')
</body>
</html>
