<?php

namespace Modules\Counseling\app\Http\Controllers\Admin;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Consultant\app\Http\Requests\ConsultantUserRequest;
use Modules\Counseling\app\Models\Consultant;
use Modules\Counseling\app\Http\Requests\CounselingStoreRequest;

class ConsultantController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        $consultants = Consultant::latest()->paginate(10);

        return view('counseling::Dashboard.Frest.consultants.index' , compact('consultants'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

        return view('counseling::Dashboard.Frest.consultants.create' );
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CounselingStoreRequest $request)
    {
        Consultant::create([
            'name' => $request->name,
            'lastname' => $request->lastname,
            'mobile' => $request->mobile,
            'image' => $request->image,
            'resume' => $request->resume,
            'body' => $request->body,
            'cat_id' => $request->cat_id,

        ]);
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.consultants.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('consultant::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Consultant $consultant)
    {
        return view('counseling::Dashboard.Frest.consultants.edit' , compact('consultant'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(CounselingStoreRequest $request, Consultant $consultant)
    {

        $consultant->mobile = $request->mobile;


        $consultant->name = $request->name;

        $consultant->lastname = $request->lastname;


        $consultant->image = $request->image;


        $consultant->resume = $request->resume;


        $consultant->body = $request->body;
        $consultant->update();

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.consultants.index');
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(Consultant $consultant)
    {
        $consultant->delete();
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }
}
