<?php

namespace Modules\Counseling\app\Http\Controllers\Admin;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Counseling\app\Models\Consultant;
use Modules\Counseling\app\Models\Counseling;
use Illuminate\Contracts\Support\Renderable;
use Modules\Counseling\app\Models\CounselingWay;
use Modules\Counseling\app\Models\CounselingType;
use Modules\Counseling\app\Models\CounselingMonth;
use Modules\Counseling\app\Http\Requests\CounselingRequest;


class CounselingController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(CounselingMonth $month)
    {


        $counselings = Counseling::where('monthId', $month->id)->paginate(15);
        return view('counseling::Dashboard.Frest.counselings.index', compact('counselings', 'month'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(CounselingMonth $month)
    {
        $consultants = Consultant::latest()->get();
        $types = CounselingType::where('lang','fa')->latest()->get();
        $ways = CounselingWay::where('lang','fa')->latest()->get();
        return view('counseling::Dashboard.Frest.counselings.create', compact('month', 'consultants', 'types', 'ways'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CounselingRequest $request, CounselingMonth $month)
    {


        $startDate = $this->changeStartDate($request->date);
        $endDate = $this->changeEndDate($startDate, $request->hours);


        $month->counselings()->create([
            'yearId' => $month->yearId,
            'consultantId' => $request->consultantId,
            'typeId' => $request->typeId,
            'wayId' => $request->wayId,
            'start_date' =>   str_replace('"', '',Str::convertToGregorian($startDate[0].':00')),
            'end_date' =>  str_replace('"', '',Str::convertToGregorian($endDate[0])),
            'price' => $request->price,
            'state' => $request->state,
        ]);

        session::flash('success', 'با موفقیت انجام شد');
        return  redirect()->route('admin.counselings.index', compact('month'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('counseling::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Counseling $counseling)
    {
        $consultants = Consultant::latest()->get();
        $types = CounselingType::where('lang','fa')->latest()->get();
        $ways = CounselingWay::where('lang','fa')->latest()->get();

        return view('counseling::Dashboard.Frest.counselings.edit', compact('counseling', 'consultants', 'types', 'ways'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request,Counseling $counseling)
    {


        $month = $counseling->month;

        $startDate = $this->changeStartDate($request->date);
        $endDate = $this->changeEndDate($startDate, $request->hours);




        $counseling->update([
            'consultantId' => $request->consultantId,
            'typeId' => $request->typeId,
            'wayId' => $request->wayId,
            'start_date' =>   str_replace('"', '',Str::convertToGregorian($startDate[0].':00')),
            'end_date' =>  str_replace('"', '',Str::convertToGregorian($endDate[0])),
            'price' => $request->price,
            'state' => $request->state,
        ]);

        session::flash('success', 'با موفقیت انجام شد');
        return  redirect()->route('admin.counselings.index', compact('month'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(Counseling $counseling)
    {
        $counseling->delete();
        session::flash('success', 'با موفقیت انجام شد');
        return  redirect()->back();
    }
    public function changeStartDate($date)
    {
        return explode('~', $date);
    }
    public function changeEndDate($dates, $hour)
    {
        $result = [];

        foreach ($dates as $temp) {
            $item =    Carbon::parse($temp)->addHour($hour);

            $result[] = $item->toDateTimeString();
        }

        return $result;
    }
}
